/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dnsresolver.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dnsresolver.fluent.models.DnsResolverDomainListPatchProperties;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class DnsResolverDomainListPatch
implements JsonSerializable<DnsResolverDomainListPatch> {
    private DnsResolverDomainListPatchProperties innerProperties;
    private Map<String, String> tags;

    private DnsResolverDomainListPatchProperties innerProperties() {
        return this.innerProperties;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public DnsResolverDomainListPatch withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public List<String> domains() {
        return this.innerProperties() == null ? null : this.innerProperties().domains();
    }

    public DnsResolverDomainListPatch withDomains(List<String> domains) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DnsResolverDomainListPatchProperties();
        }
        this.innerProperties().withDomains(domains);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static DnsResolverDomainListPatch fromJson(JsonReader jsonReader) throws IOException {
        return (DnsResolverDomainListPatch)jsonReader.readObject(reader -> {
            DnsResolverDomainListPatch deserializedDnsResolverDomainListPatch = new DnsResolverDomainListPatch();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedDnsResolverDomainListPatch.innerProperties = DnsResolverDomainListPatchProperties.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedDnsResolverDomainListPatch.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDnsResolverDomainListPatch;
        });
    }
}

