/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dnsresolver.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.util.CoreUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import reactor.core.publisher.Flux;

final class ResourceManagerUtils {
    private ResourceManagerUtils() {
    }

    static String getValueFromIdByName(String id, String name) {
        if (id == null) {
            return null;
        }
        Iterator itr = Arrays.stream(id.split("/")).iterator();
        while (itr.hasNext()) {
            String part = (String)itr.next();
            if (part == null || part.trim().isEmpty() || !part.equalsIgnoreCase(name)) continue;
            if (itr.hasNext()) {
                return (String)itr.next();
            }
            return null;
        }
        return null;
    }

    static String getValueFromIdByParameterName(String id, String pathTemplate, String parameterName) {
        if (id == null || pathTemplate == null) {
            return null;
        }
        String parameterNameParentheses = "{" + parameterName + "}";
        List<String> idSegmentsReverted = Arrays.asList(id.split("/"));
        List<String> pathSegments = Arrays.asList(pathTemplate.split("/"));
        Collections.reverse(idSegmentsReverted);
        Iterator<String> idItrReverted = idSegmentsReverted.iterator();
        int pathIndex = pathSegments.size();
        while (idItrReverted.hasNext() && pathIndex > 0) {
            String idSegment = idItrReverted.next();
            String pathSegment = pathSegments.get(--pathIndex);
            if (CoreUtils.isNullOrEmpty((CharSequence)idSegment) || CoreUtils.isNullOrEmpty((CharSequence)pathSegment) || !pathSegment.equalsIgnoreCase(parameterNameParentheses)) continue;
            if (pathIndex == 0 || pathIndex == 1 && pathSegments.get(0).isEmpty()) {
                ArrayList<String> segments = new ArrayList<String>();
                segments.add(idSegment);
                idItrReverted.forEachRemaining(segments::add);
                Collections.reverse(segments);
                if (!segments.isEmpty() && ((String)segments.get(0)).isEmpty()) {
                    segments.remove(0);
                }
                return String.join((CharSequence)"/", segments);
            }
            return idSegment;
        }
        return null;
    }

    static <T, S> PagedIterable<S> mapPage(PagedIterable<T> pageIterable, Function<T, S> mapper) {
        return new PagedIterableImpl(pageIterable, mapper);
    }

    private static final class PagedIterableImpl<T, S>
    extends PagedIterable<S> {
        private final PagedIterable<T> pagedIterable;
        private final Function<T, S> mapper;
        private final Function<PagedResponse<T>, PagedResponse<S>> pageMapper;

        private PagedIterableImpl(PagedIterable<T> pagedIterable, Function<T, S> mapper) {
            super(PagedFlux.create(() -> (continuationToken, pageSize) -> Flux.fromStream(pagedIterable.streamByPage().map(PagedIterableImpl.getPageMapper(mapper)))));
            this.pagedIterable = pagedIterable;
            this.mapper = mapper;
            this.pageMapper = PagedIterableImpl.getPageMapper(mapper);
        }

        private static <T, S> Function<PagedResponse<T>, PagedResponse<S>> getPageMapper(Function<T, S> mapper) {
            return page -> new PagedResponseBase(page.getRequest(), page.getStatusCode(), page.getHeaders(), page.getElements().stream().map(mapper).collect(Collectors.toList()), (String)page.getContinuationToken(), null);
        }

        public Stream<S> stream() {
            return this.pagedIterable.stream().map(this.mapper);
        }

        public Stream<PagedResponse<S>> streamByPage() {
            return this.pagedIterable.streamByPage().map(this.pageMapper);
        }

        public Stream<PagedResponse<S>> streamByPage(String continuationToken) {
            return this.pagedIterable.streamByPage((Object)continuationToken).map(this.pageMapper);
        }

        public Stream<PagedResponse<S>> streamByPage(int preferredPageSize) {
            return this.pagedIterable.streamByPage(preferredPageSize).map(this.pageMapper);
        }

        public Stream<PagedResponse<S>> streamByPage(String continuationToken, int preferredPageSize) {
            return this.pagedIterable.streamByPage((Object)continuationToken, preferredPageSize).map(this.pageMapper);
        }

        public Iterator<S> iterator() {
            return new IteratorImpl(this.pagedIterable.iterator(), this.mapper);
        }

        public Iterable<PagedResponse<S>> iterableByPage() {
            return new IterableImpl(this.pagedIterable.iterableByPage(), this.pageMapper);
        }

        public Iterable<PagedResponse<S>> iterableByPage(String continuationToken) {
            return new IterableImpl(this.pagedIterable.iterableByPage((Object)continuationToken), this.pageMapper);
        }

        public Iterable<PagedResponse<S>> iterableByPage(int preferredPageSize) {
            return new IterableImpl(this.pagedIterable.iterableByPage(preferredPageSize), this.pageMapper);
        }

        public Iterable<PagedResponse<S>> iterableByPage(String continuationToken, int preferredPageSize) {
            return new IterableImpl(this.pagedIterable.iterableByPage((Object)continuationToken, preferredPageSize), this.pageMapper);
        }
    }

    private static final class IterableImpl<T, S>
    implements Iterable<S> {
        private final Iterable<T> iterable;
        private final Function<T, S> mapper;

        private IterableImpl(Iterable<T> iterable, Function<T, S> mapper) {
            this.iterable = iterable;
            this.mapper = mapper;
        }

        @Override
        public Iterator<S> iterator() {
            return new IteratorImpl(this.iterable.iterator(), this.mapper);
        }
    }

    private static final class IteratorImpl<T, S>
    implements Iterator<S> {
        private final Iterator<T> iterator;
        private final Function<T, S> mapper;

        private IteratorImpl(Iterator<T> iterator, Function<T, S> mapper) {
            this.iterator = iterator;
            this.mapper = mapper;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public S next() {
            return this.mapper.apply(this.iterator.next());
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

