/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dnsresolver.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.dnsresolver.fluent.InboundEndpointsClient;
import com.azure.resourcemanager.dnsresolver.fluent.models.InboundEndpointInner;
import com.azure.resourcemanager.dnsresolver.implementation.DnsResolverManagementClientImpl;
import com.azure.resourcemanager.dnsresolver.models.InboundEndpointListResult;
import com.azure.resourcemanager.dnsresolver.models.InboundEndpointPatch;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class InboundEndpointsClientImpl
implements InboundEndpointsClient {
    private final InboundEndpointsService service;
    private final DnsResolverManagementClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(InboundEndpointsClientImpl.class);

    InboundEndpointsClientImpl(DnsResolverManagementClientImpl client) {
        this.service = (InboundEndpointsService)RestProxy.create(InboundEndpointsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String dnsResolverName, String inboundEndpointName, InboundEndpointInner parameters, String ifMatch, String ifNoneMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (dnsResolverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter dnsResolverName is required and cannot be null."));
        }
        if (inboundEndpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter inboundEndpointName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, dnsResolverName, inboundEndpointName, this.client.getApiVersion(), ifMatch, ifNoneMatch, parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String dnsResolverName, String inboundEndpointName, InboundEndpointInner parameters, String ifMatch, String ifNoneMatch) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (dnsResolverName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter dnsResolverName is required and cannot be null."));
        }
        if (inboundEndpointName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter inboundEndpointName is required and cannot be null."));
        }
        if (parameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, dnsResolverName, inboundEndpointName, this.client.getApiVersion(), ifMatch, ifNoneMatch, parameters, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String dnsResolverName, String inboundEndpointName, InboundEndpointInner parameters, String ifMatch, String ifNoneMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (dnsResolverName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter dnsResolverName is required and cannot be null."));
        }
        if (inboundEndpointName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter inboundEndpointName is required and cannot be null."));
        }
        if (parameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, dnsResolverName, inboundEndpointName, this.client.getApiVersion(), ifMatch, ifNoneMatch, parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<InboundEndpointInner>, InboundEndpointInner> beginCreateOrUpdateAsync(String resourceGroupName, String dnsResolverName, String inboundEndpointName, InboundEndpointInner parameters, String ifMatch, String ifNoneMatch) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, dnsResolverName, inboundEndpointName, parameters, ifMatch, ifNoneMatch);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)InboundEndpointInner.class), (Type)((Object)InboundEndpointInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<InboundEndpointInner>, InboundEndpointInner> beginCreateOrUpdateAsync(String resourceGroupName, String dnsResolverName, String inboundEndpointName, InboundEndpointInner parameters) {
        String ifMatch = null;
        String ifNoneMatch = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, dnsResolverName, inboundEndpointName, parameters, ifMatch, ifNoneMatch);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)InboundEndpointInner.class), (Type)((Object)InboundEndpointInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<InboundEndpointInner>, InboundEndpointInner> beginCreateOrUpdate(String resourceGroupName, String dnsResolverName, String inboundEndpointName, InboundEndpointInner parameters, String ifMatch, String ifNoneMatch) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, dnsResolverName, inboundEndpointName, parameters, ifMatch, ifNoneMatch);
        return this.client.getLroResult(response, (Type)((Object)InboundEndpointInner.class), (Type)((Object)InboundEndpointInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<InboundEndpointInner>, InboundEndpointInner> beginCreateOrUpdate(String resourceGroupName, String dnsResolverName, String inboundEndpointName, InboundEndpointInner parameters) {
        String ifMatch = null;
        String ifNoneMatch = null;
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, dnsResolverName, inboundEndpointName, parameters, ifMatch, ifNoneMatch);
        return this.client.getLroResult(response, (Type)((Object)InboundEndpointInner.class), (Type)((Object)InboundEndpointInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<InboundEndpointInner>, InboundEndpointInner> beginCreateOrUpdate(String resourceGroupName, String dnsResolverName, String inboundEndpointName, InboundEndpointInner parameters, String ifMatch, String ifNoneMatch, Context context) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, dnsResolverName, inboundEndpointName, parameters, ifMatch, ifNoneMatch, context);
        return this.client.getLroResult(response, (Type)((Object)InboundEndpointInner.class), (Type)((Object)InboundEndpointInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<InboundEndpointInner> createOrUpdateAsync(String resourceGroupName, String dnsResolverName, String inboundEndpointName, InboundEndpointInner parameters, String ifMatch, String ifNoneMatch) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, dnsResolverName, inboundEndpointName, parameters, ifMatch, ifNoneMatch).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<InboundEndpointInner> createOrUpdateAsync(String resourceGroupName, String dnsResolverName, String inboundEndpointName, InboundEndpointInner parameters) {
        String ifMatch = null;
        String ifNoneMatch = null;
        return this.beginCreateOrUpdateAsync(resourceGroupName, dnsResolverName, inboundEndpointName, parameters, ifMatch, ifNoneMatch).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public InboundEndpointInner createOrUpdate(String resourceGroupName, String dnsResolverName, String inboundEndpointName, InboundEndpointInner parameters) {
        String ifMatch = null;
        String ifNoneMatch = null;
        return (InboundEndpointInner)((Object)this.beginCreateOrUpdate(resourceGroupName, dnsResolverName, inboundEndpointName, parameters, ifMatch, ifNoneMatch).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public InboundEndpointInner createOrUpdate(String resourceGroupName, String dnsResolverName, String inboundEndpointName, InboundEndpointInner parameters, String ifMatch, String ifNoneMatch, Context context) {
        return (InboundEndpointInner)((Object)this.beginCreateOrUpdate(resourceGroupName, dnsResolverName, inboundEndpointName, parameters, ifMatch, ifNoneMatch, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String dnsResolverName, String inboundEndpointName, InboundEndpointPatch parameters, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (dnsResolverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter dnsResolverName is required and cannot be null."));
        }
        if (inboundEndpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter inboundEndpointName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, dnsResolverName, inboundEndpointName, this.client.getApiVersion(), ifMatch, parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String dnsResolverName, String inboundEndpointName, InboundEndpointPatch parameters, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (dnsResolverName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter dnsResolverName is required and cannot be null."));
        }
        if (inboundEndpointName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter inboundEndpointName is required and cannot be null."));
        }
        if (parameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, dnsResolverName, inboundEndpointName, this.client.getApiVersion(), ifMatch, parameters, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String dnsResolverName, String inboundEndpointName, InboundEndpointPatch parameters, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (dnsResolverName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter dnsResolverName is required and cannot be null."));
        }
        if (inboundEndpointName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter inboundEndpointName is required and cannot be null."));
        }
        if (parameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, dnsResolverName, inboundEndpointName, this.client.getApiVersion(), ifMatch, parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<InboundEndpointInner>, InboundEndpointInner> beginUpdateAsync(String resourceGroupName, String dnsResolverName, String inboundEndpointName, InboundEndpointPatch parameters, String ifMatch) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, dnsResolverName, inboundEndpointName, parameters, ifMatch);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)InboundEndpointInner.class), (Type)((Object)InboundEndpointInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<InboundEndpointInner>, InboundEndpointInner> beginUpdateAsync(String resourceGroupName, String dnsResolverName, String inboundEndpointName, InboundEndpointPatch parameters) {
        String ifMatch = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, dnsResolverName, inboundEndpointName, parameters, ifMatch);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)InboundEndpointInner.class), (Type)((Object)InboundEndpointInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<InboundEndpointInner>, InboundEndpointInner> beginUpdate(String resourceGroupName, String dnsResolverName, String inboundEndpointName, InboundEndpointPatch parameters, String ifMatch) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, dnsResolverName, inboundEndpointName, parameters, ifMatch);
        return this.client.getLroResult(response, (Type)((Object)InboundEndpointInner.class), (Type)((Object)InboundEndpointInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<InboundEndpointInner>, InboundEndpointInner> beginUpdate(String resourceGroupName, String dnsResolverName, String inboundEndpointName, InboundEndpointPatch parameters) {
        String ifMatch = null;
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, dnsResolverName, inboundEndpointName, parameters, ifMatch);
        return this.client.getLroResult(response, (Type)((Object)InboundEndpointInner.class), (Type)((Object)InboundEndpointInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<InboundEndpointInner>, InboundEndpointInner> beginUpdate(String resourceGroupName, String dnsResolverName, String inboundEndpointName, InboundEndpointPatch parameters, String ifMatch, Context context) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, dnsResolverName, inboundEndpointName, parameters, ifMatch, context);
        return this.client.getLroResult(response, (Type)((Object)InboundEndpointInner.class), (Type)((Object)InboundEndpointInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<InboundEndpointInner> updateAsync(String resourceGroupName, String dnsResolverName, String inboundEndpointName, InboundEndpointPatch parameters, String ifMatch) {
        return this.beginUpdateAsync(resourceGroupName, dnsResolverName, inboundEndpointName, parameters, ifMatch).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<InboundEndpointInner> updateAsync(String resourceGroupName, String dnsResolverName, String inboundEndpointName, InboundEndpointPatch parameters) {
        String ifMatch = null;
        return this.beginUpdateAsync(resourceGroupName, dnsResolverName, inboundEndpointName, parameters, ifMatch).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public InboundEndpointInner update(String resourceGroupName, String dnsResolverName, String inboundEndpointName, InboundEndpointPatch parameters) {
        String ifMatch = null;
        return (InboundEndpointInner)((Object)this.beginUpdate(resourceGroupName, dnsResolverName, inboundEndpointName, parameters, ifMatch).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public InboundEndpointInner update(String resourceGroupName, String dnsResolverName, String inboundEndpointName, InboundEndpointPatch parameters, String ifMatch, Context context) {
        return (InboundEndpointInner)((Object)this.beginUpdate(resourceGroupName, dnsResolverName, inboundEndpointName, parameters, ifMatch, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String dnsResolverName, String inboundEndpointName, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (dnsResolverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter dnsResolverName is required and cannot be null."));
        }
        if (inboundEndpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter inboundEndpointName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, dnsResolverName, inboundEndpointName, this.client.getApiVersion(), ifMatch, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String dnsResolverName, String inboundEndpointName, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (dnsResolverName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter dnsResolverName is required and cannot be null."));
        }
        if (inboundEndpointName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter inboundEndpointName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, dnsResolverName, inboundEndpointName, this.client.getApiVersion(), ifMatch, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String dnsResolverName, String inboundEndpointName, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (dnsResolverName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter dnsResolverName is required and cannot be null."));
        }
        if (inboundEndpointName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter inboundEndpointName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, dnsResolverName, inboundEndpointName, this.client.getApiVersion(), ifMatch, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String dnsResolverName, String inboundEndpointName, String ifMatch) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, dnsResolverName, inboundEndpointName, ifMatch);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String dnsResolverName, String inboundEndpointName) {
        String ifMatch = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, dnsResolverName, inboundEndpointName, ifMatch);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String dnsResolverName, String inboundEndpointName, String ifMatch) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, dnsResolverName, inboundEndpointName, ifMatch);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String dnsResolverName, String inboundEndpointName) {
        String ifMatch = null;
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, dnsResolverName, inboundEndpointName, ifMatch);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String dnsResolverName, String inboundEndpointName, String ifMatch, Context context) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, dnsResolverName, inboundEndpointName, ifMatch, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String dnsResolverName, String inboundEndpointName, String ifMatch) {
        return this.beginDeleteAsync(resourceGroupName, dnsResolverName, inboundEndpointName, ifMatch).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String dnsResolverName, String inboundEndpointName) {
        String ifMatch = null;
        return this.beginDeleteAsync(resourceGroupName, dnsResolverName, inboundEndpointName, ifMatch).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String dnsResolverName, String inboundEndpointName) {
        String ifMatch = null;
        this.beginDelete(resourceGroupName, dnsResolverName, inboundEndpointName, ifMatch).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String dnsResolverName, String inboundEndpointName, String ifMatch, Context context) {
        this.beginDelete(resourceGroupName, dnsResolverName, inboundEndpointName, ifMatch, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<InboundEndpointInner>> getWithResponseAsync(String resourceGroupName, String dnsResolverName, String inboundEndpointName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (dnsResolverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter dnsResolverName is required and cannot be null."));
        }
        if (inboundEndpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter inboundEndpointName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, dnsResolverName, inboundEndpointName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<InboundEndpointInner> getAsync(String resourceGroupName, String dnsResolverName, String inboundEndpointName) {
        return this.getWithResponseAsync(resourceGroupName, dnsResolverName, inboundEndpointName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((InboundEndpointInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<InboundEndpointInner> getWithResponse(String resourceGroupName, String dnsResolverName, String inboundEndpointName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (dnsResolverName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter dnsResolverName is required and cannot be null."));
        }
        if (inboundEndpointName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter inboundEndpointName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, dnsResolverName, inboundEndpointName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public InboundEndpointInner get(String resourceGroupName, String dnsResolverName, String inboundEndpointName) {
        return (InboundEndpointInner)((Object)this.getWithResponse(resourceGroupName, dnsResolverName, inboundEndpointName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<InboundEndpointInner>> listSinglePageAsync(String resourceGroupName, String dnsResolverName, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (dnsResolverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter dnsResolverName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, dnsResolverName, this.client.getApiVersion(), top, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((InboundEndpointListResult)res.getValue()).value(), ((InboundEndpointListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<InboundEndpointInner> listAsync(String resourceGroupName, String dnsResolverName, Integer top) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, dnsResolverName, top), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<InboundEndpointInner> listAsync(String resourceGroupName, String dnsResolverName) {
        Integer top = null;
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, dnsResolverName, top), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<InboundEndpointInner> listSinglePage(String resourceGroupName, String dnsResolverName, Integer top) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (dnsResolverName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter dnsResolverName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<InboundEndpointListResult> res = this.service.listSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, dnsResolverName, this.client.getApiVersion(), top, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((InboundEndpointListResult)res.getValue()).value(), ((InboundEndpointListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<InboundEndpointInner> listSinglePage(String resourceGroupName, String dnsResolverName, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (dnsResolverName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter dnsResolverName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<InboundEndpointListResult> res = this.service.listSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, dnsResolverName, this.client.getApiVersion(), top, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((InboundEndpointListResult)res.getValue()).value(), ((InboundEndpointListResult)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<InboundEndpointInner> list(String resourceGroupName, String dnsResolverName) {
        Integer top = null;
        return new PagedIterable(() -> this.listSinglePage(resourceGroupName, dnsResolverName, top), nextLink -> this.listNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<InboundEndpointInner> list(String resourceGroupName, String dnsResolverName, Integer top, Context context) {
        return new PagedIterable(() -> this.listSinglePage(resourceGroupName, dnsResolverName, top, context), nextLink -> this.listNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<InboundEndpointInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((InboundEndpointListResult)res.getValue()).value(), ((InboundEndpointListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<InboundEndpointInner> listNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<InboundEndpointListResult> res = this.service.listNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((InboundEndpointListResult)res.getValue()).value(), ((InboundEndpointListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<InboundEndpointInner> listNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<InboundEndpointListResult> res = this.service.listNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((InboundEndpointListResult)res.getValue()).value(), ((InboundEndpointListResult)res.getValue()).nextLink(), null);
    }

    @Host(value="{$host}")
    @ServiceInterface(name="DnsResolverManagementClientInboundEndpoints")
    public static interface InboundEndpointsService {
        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolvers/{dnsResolverName}/inboundEndpoints/{inboundEndpointName}")
        @ExpectedResponses(value={200, 201, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="dnsResolverName") String var4, @PathParam(value="inboundEndpointName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="If-Match") String var7, @HeaderParam(value="If-None-Match") String var8, @BodyParam(value="application/json") InboundEndpointInner var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolvers/{dnsResolverName}/inboundEndpoints/{inboundEndpointName}")
        @ExpectedResponses(value={200, 201, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> createOrUpdateSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="dnsResolverName") String var4, @PathParam(value="inboundEndpointName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="If-Match") String var7, @HeaderParam(value="If-None-Match") String var8, @BodyParam(value="application/json") InboundEndpointInner var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolvers/{dnsResolverName}/inboundEndpoints/{inboundEndpointName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="dnsResolverName") String var4, @PathParam(value="inboundEndpointName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="If-Match") String var7, @BodyParam(value="application/json") InboundEndpointPatch var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolvers/{dnsResolverName}/inboundEndpoints/{inboundEndpointName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> updateSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="dnsResolverName") String var4, @PathParam(value="inboundEndpointName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="If-Match") String var7, @BodyParam(value="application/json") InboundEndpointPatch var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolvers/{dnsResolverName}/inboundEndpoints/{inboundEndpointName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="dnsResolverName") String var4, @PathParam(value="inboundEndpointName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="If-Match") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolvers/{dnsResolverName}/inboundEndpoints/{inboundEndpointName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> deleteSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="dnsResolverName") String var4, @PathParam(value="inboundEndpointName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="If-Match") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolvers/{dnsResolverName}/inboundEndpoints/{inboundEndpointName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<InboundEndpointInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="dnsResolverName") String var4, @PathParam(value="inboundEndpointName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolvers/{dnsResolverName}/inboundEndpoints/{inboundEndpointName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<InboundEndpointInner> getSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="dnsResolverName") String var4, @PathParam(value="inboundEndpointName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolvers/{dnsResolverName}/inboundEndpoints")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<InboundEndpointListResult>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="dnsResolverName") String var4, @QueryParam(value="api-version") String var5, @QueryParam(value="$top") Integer var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolvers/{dnsResolverName}/inboundEndpoints")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<InboundEndpointListResult> listSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="dnsResolverName") String var4, @QueryParam(value="api-version") String var5, @QueryParam(value="$top") Integer var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<InboundEndpointListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<InboundEndpointListResult> listNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

