/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dnsresolver.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.dnsresolver.DnsResolverManager;
import com.azure.resourcemanager.dnsresolver.fluent.models.ForwardingRuleInner;
import com.azure.resourcemanager.dnsresolver.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.dnsresolver.models.ForwardingRule;
import com.azure.resourcemanager.dnsresolver.models.ForwardingRulePatch;
import com.azure.resourcemanager.dnsresolver.models.ForwardingRuleState;
import com.azure.resourcemanager.dnsresolver.models.ProvisioningState;
import com.azure.resourcemanager.dnsresolver.models.TargetDnsServer;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class ForwardingRuleImpl
implements ForwardingRule,
ForwardingRule.Definition,
ForwardingRule.Update {
    private ForwardingRuleInner innerObject;
    private final DnsResolverManager serviceManager;
    private String resourceGroupName;
    private String dnsForwardingRulesetName;
    private String forwardingRuleName;
    private String createIfMatch;
    private String createIfNoneMatch;
    private String updateIfMatch;
    private ForwardingRulePatch updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String domainName() {
        return this.innerModel().domainName();
    }

    @Override
    public List<TargetDnsServer> targetDnsServers() {
        List<TargetDnsServer> inner = this.innerModel().targetDnsServers();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public Map<String, String> metadata() {
        Map<String, String> inner = this.innerModel().metadata();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public ForwardingRuleState forwardingRuleState() {
        return this.innerModel().forwardingRuleState();
    }

    @Override
    public ProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ForwardingRuleInner innerModel() {
        return this.innerObject;
    }

    private DnsResolverManager manager() {
        return this.serviceManager;
    }

    @Override
    public ForwardingRuleImpl withExistingDnsForwardingRuleset(String resourceGroupName, String dnsForwardingRulesetName) {
        this.resourceGroupName = resourceGroupName;
        this.dnsForwardingRulesetName = dnsForwardingRulesetName;
        return this;
    }

    @Override
    public ForwardingRule create() {
        this.innerObject = (ForwardingRuleInner)((Object)this.serviceManager.serviceClient().getForwardingRules().createOrUpdateWithResponse(this.resourceGroupName, this.dnsForwardingRulesetName, this.forwardingRuleName, this.innerModel(), this.createIfMatch, this.createIfNoneMatch, Context.NONE).getValue());
        return this;
    }

    @Override
    public ForwardingRule create(Context context) {
        this.innerObject = (ForwardingRuleInner)((Object)this.serviceManager.serviceClient().getForwardingRules().createOrUpdateWithResponse(this.resourceGroupName, this.dnsForwardingRulesetName, this.forwardingRuleName, this.innerModel(), this.createIfMatch, this.createIfNoneMatch, context).getValue());
        return this;
    }

    ForwardingRuleImpl(String name, DnsResolverManager serviceManager) {
        this.innerObject = new ForwardingRuleInner();
        this.serviceManager = serviceManager;
        this.forwardingRuleName = name;
        this.createIfMatch = null;
        this.createIfNoneMatch = null;
    }

    @Override
    public ForwardingRuleImpl update() {
        this.updateIfMatch = null;
        this.updateParameters = new ForwardingRulePatch();
        return this;
    }

    @Override
    public ForwardingRule apply() {
        this.innerObject = (ForwardingRuleInner)((Object)this.serviceManager.serviceClient().getForwardingRules().updateWithResponse(this.resourceGroupName, this.dnsForwardingRulesetName, this.forwardingRuleName, this.updateParameters, this.updateIfMatch, Context.NONE).getValue());
        return this;
    }

    @Override
    public ForwardingRule apply(Context context) {
        this.innerObject = (ForwardingRuleInner)((Object)this.serviceManager.serviceClient().getForwardingRules().updateWithResponse(this.resourceGroupName, this.dnsForwardingRulesetName, this.forwardingRuleName, this.updateParameters, this.updateIfMatch, context).getValue());
        return this;
    }

    ForwardingRuleImpl(ForwardingRuleInner innerObject, DnsResolverManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.dnsForwardingRulesetName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "dnsForwardingRulesets");
        this.forwardingRuleName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "forwardingRules");
    }

    @Override
    public ForwardingRule refresh() {
        this.innerObject = (ForwardingRuleInner)((Object)this.serviceManager.serviceClient().getForwardingRules().getWithResponse(this.resourceGroupName, this.dnsForwardingRulesetName, this.forwardingRuleName, Context.NONE).getValue());
        return this;
    }

    @Override
    public ForwardingRule refresh(Context context) {
        this.innerObject = (ForwardingRuleInner)((Object)this.serviceManager.serviceClient().getForwardingRules().getWithResponse(this.resourceGroupName, this.dnsForwardingRulesetName, this.forwardingRuleName, context).getValue());
        return this;
    }

    @Override
    public ForwardingRuleImpl withDomainName(String domainName) {
        this.innerModel().withDomainName(domainName);
        return this;
    }

    @Override
    public ForwardingRuleImpl withTargetDnsServers(List<TargetDnsServer> targetDnsServers) {
        if (this.isInCreateMode()) {
            this.innerModel().withTargetDnsServers(targetDnsServers);
            return this;
        }
        this.updateParameters.withTargetDnsServers(targetDnsServers);
        return this;
    }

    @Override
    public ForwardingRuleImpl withMetadata(Map<String, String> metadata) {
        if (this.isInCreateMode()) {
            this.innerModel().withMetadata(metadata);
            return this;
        }
        this.updateParameters.withMetadata(metadata);
        return this;
    }

    @Override
    public ForwardingRuleImpl withForwardingRuleState(ForwardingRuleState forwardingRuleState) {
        if (this.isInCreateMode()) {
            this.innerModel().withForwardingRuleState(forwardingRuleState);
            return this;
        }
        this.updateParameters.withForwardingRuleState(forwardingRuleState);
        return this;
    }

    @Override
    public ForwardingRuleImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    @Override
    public ForwardingRuleImpl withIfNoneMatch(String ifNoneMatch) {
        this.createIfNoneMatch = ifNoneMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

