/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dnsresolver.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.dnsresolver.DnsResolverManager;
import com.azure.resourcemanager.dnsresolver.fluent.DnsSecurityRulesClient;
import com.azure.resourcemanager.dnsresolver.fluent.models.DnsSecurityRuleInner;
import com.azure.resourcemanager.dnsresolver.implementation.DnsSecurityRuleImpl;
import com.azure.resourcemanager.dnsresolver.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.dnsresolver.models.DnsSecurityRule;
import com.azure.resourcemanager.dnsresolver.models.DnsSecurityRules;

public final class DnsSecurityRulesImpl
implements DnsSecurityRules {
    private static final ClientLogger LOGGER = new ClientLogger(DnsSecurityRulesImpl.class);
    private final DnsSecurityRulesClient innerClient;
    private final DnsResolverManager serviceManager;

    public DnsSecurityRulesImpl(DnsSecurityRulesClient innerClient, DnsResolverManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public void delete(String resourceGroupName, String dnsResolverPolicyName, String dnsSecurityRuleName) {
        this.serviceClient().delete(resourceGroupName, dnsResolverPolicyName, dnsSecurityRuleName);
    }

    @Override
    public void delete(String resourceGroupName, String dnsResolverPolicyName, String dnsSecurityRuleName, String ifMatch, Context context) {
        this.serviceClient().delete(resourceGroupName, dnsResolverPolicyName, dnsSecurityRuleName, ifMatch, context);
    }

    @Override
    public Response<DnsSecurityRule> getWithResponse(String resourceGroupName, String dnsResolverPolicyName, String dnsSecurityRuleName, Context context) {
        Response<DnsSecurityRuleInner> inner = this.serviceClient().getWithResponse(resourceGroupName, dnsResolverPolicyName, dnsSecurityRuleName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DnsSecurityRuleImpl((DnsSecurityRuleInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public DnsSecurityRule get(String resourceGroupName, String dnsResolverPolicyName, String dnsSecurityRuleName) {
        DnsSecurityRuleInner inner = this.serviceClient().get(resourceGroupName, dnsResolverPolicyName, dnsSecurityRuleName);
        if (inner != null) {
            return new DnsSecurityRuleImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<DnsSecurityRule> list(String resourceGroupName, String dnsResolverPolicyName) {
        PagedIterable<DnsSecurityRuleInner> inner = this.serviceClient().list(resourceGroupName, dnsResolverPolicyName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DnsSecurityRuleImpl((DnsSecurityRuleInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DnsSecurityRule> list(String resourceGroupName, String dnsResolverPolicyName, Integer top, Context context) {
        PagedIterable<DnsSecurityRuleInner> inner = this.serviceClient().list(resourceGroupName, dnsResolverPolicyName, top, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DnsSecurityRuleImpl((DnsSecurityRuleInner)((Object)inner1), this.manager()));
    }

    @Override
    public DnsSecurityRule getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String dnsResolverPolicyName = ResourceManagerUtils.getValueFromIdByName(id, "dnsResolverPolicies");
        if (dnsResolverPolicyName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dnsResolverPolicies'.", id)));
        }
        String dnsSecurityRuleName = ResourceManagerUtils.getValueFromIdByName(id, "dnsSecurityRules");
        if (dnsSecurityRuleName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dnsSecurityRules'.", id)));
        }
        return (DnsSecurityRule)this.getWithResponse(resourceGroupName, dnsResolverPolicyName, dnsSecurityRuleName, Context.NONE).getValue();
    }

    @Override
    public Response<DnsSecurityRule> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String dnsResolverPolicyName = ResourceManagerUtils.getValueFromIdByName(id, "dnsResolverPolicies");
        if (dnsResolverPolicyName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dnsResolverPolicies'.", id)));
        }
        String dnsSecurityRuleName = ResourceManagerUtils.getValueFromIdByName(id, "dnsSecurityRules");
        if (dnsSecurityRuleName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dnsSecurityRules'.", id)));
        }
        return this.getWithResponse(resourceGroupName, dnsResolverPolicyName, dnsSecurityRuleName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String dnsResolverPolicyName = ResourceManagerUtils.getValueFromIdByName(id, "dnsResolverPolicies");
        if (dnsResolverPolicyName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dnsResolverPolicies'.", id)));
        }
        String dnsSecurityRuleName = ResourceManagerUtils.getValueFromIdByName(id, "dnsSecurityRules");
        if (dnsSecurityRuleName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dnsSecurityRules'.", id)));
        }
        String localIfMatch = null;
        this.delete(resourceGroupName, dnsResolverPolicyName, dnsSecurityRuleName, localIfMatch, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, String ifMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String dnsResolverPolicyName = ResourceManagerUtils.getValueFromIdByName(id, "dnsResolverPolicies");
        if (dnsResolverPolicyName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dnsResolverPolicies'.", id)));
        }
        String dnsSecurityRuleName = ResourceManagerUtils.getValueFromIdByName(id, "dnsSecurityRules");
        if (dnsSecurityRuleName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dnsSecurityRules'.", id)));
        }
        this.delete(resourceGroupName, dnsResolverPolicyName, dnsSecurityRuleName, ifMatch, context);
    }

    private DnsSecurityRulesClient serviceClient() {
        return this.innerClient;
    }

    private DnsResolverManager manager() {
        return this.serviceManager;
    }

    @Override
    public DnsSecurityRuleImpl define(String name) {
        return new DnsSecurityRuleImpl(name, this.manager());
    }
}

