/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dnsresolver.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SubResource;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.dnsresolver.DnsResolverManager;
import com.azure.resourcemanager.dnsresolver.fluent.models.DnsSecurityRuleInner;
import com.azure.resourcemanager.dnsresolver.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.dnsresolver.models.DnsSecurityRule;
import com.azure.resourcemanager.dnsresolver.models.DnsSecurityRuleAction;
import com.azure.resourcemanager.dnsresolver.models.DnsSecurityRulePatch;
import com.azure.resourcemanager.dnsresolver.models.DnsSecurityRuleState;
import com.azure.resourcemanager.dnsresolver.models.ProvisioningState;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class DnsSecurityRuleImpl
implements DnsSecurityRule,
DnsSecurityRule.Definition,
DnsSecurityRule.Update {
    private DnsSecurityRuleInner innerObject;
    private final DnsResolverManager serviceManager;
    private String resourceGroupName;
    private String dnsResolverPolicyName;
    private String dnsSecurityRuleName;
    private String createIfMatch;
    private String createIfNoneMatch;
    private String updateIfMatch;
    private DnsSecurityRulePatch updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public int priority() {
        return this.innerModel().priority();
    }

    @Override
    public DnsSecurityRuleAction action() {
        return this.innerModel().action();
    }

    @Override
    public List<SubResource> dnsResolverDomainLists() {
        List<SubResource> inner = this.innerModel().dnsResolverDomainLists();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public DnsSecurityRuleState dnsSecurityRuleState() {
        return this.innerModel().dnsSecurityRuleState();
    }

    @Override
    public ProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public DnsSecurityRuleInner innerModel() {
        return this.innerObject;
    }

    private DnsResolverManager manager() {
        return this.serviceManager;
    }

    @Override
    public DnsSecurityRuleImpl withExistingDnsResolverPolicy(String resourceGroupName, String dnsResolverPolicyName) {
        this.resourceGroupName = resourceGroupName;
        this.dnsResolverPolicyName = dnsResolverPolicyName;
        return this;
    }

    @Override
    public DnsSecurityRule create() {
        this.innerObject = this.serviceManager.serviceClient().getDnsSecurityRules().createOrUpdate(this.resourceGroupName, this.dnsResolverPolicyName, this.dnsSecurityRuleName, this.innerModel(), this.createIfMatch, this.createIfNoneMatch, Context.NONE);
        return this;
    }

    @Override
    public DnsSecurityRule create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getDnsSecurityRules().createOrUpdate(this.resourceGroupName, this.dnsResolverPolicyName, this.dnsSecurityRuleName, this.innerModel(), this.createIfMatch, this.createIfNoneMatch, context);
        return this;
    }

    DnsSecurityRuleImpl(String name, DnsResolverManager serviceManager) {
        this.innerObject = new DnsSecurityRuleInner();
        this.serviceManager = serviceManager;
        this.dnsSecurityRuleName = name;
        this.createIfMatch = null;
        this.createIfNoneMatch = null;
    }

    @Override
    public DnsSecurityRuleImpl update() {
        this.updateIfMatch = null;
        this.updateParameters = new DnsSecurityRulePatch();
        return this;
    }

    @Override
    public DnsSecurityRule apply() {
        this.innerObject = this.serviceManager.serviceClient().getDnsSecurityRules().update(this.resourceGroupName, this.dnsResolverPolicyName, this.dnsSecurityRuleName, this.updateParameters, this.updateIfMatch, Context.NONE);
        return this;
    }

    @Override
    public DnsSecurityRule apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getDnsSecurityRules().update(this.resourceGroupName, this.dnsResolverPolicyName, this.dnsSecurityRuleName, this.updateParameters, this.updateIfMatch, context);
        return this;
    }

    DnsSecurityRuleImpl(DnsSecurityRuleInner innerObject, DnsResolverManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.dnsResolverPolicyName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "dnsResolverPolicies");
        this.dnsSecurityRuleName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "dnsSecurityRules");
    }

    @Override
    public DnsSecurityRule refresh() {
        this.innerObject = (DnsSecurityRuleInner)((Object)this.serviceManager.serviceClient().getDnsSecurityRules().getWithResponse(this.resourceGroupName, this.dnsResolverPolicyName, this.dnsSecurityRuleName, Context.NONE).getValue());
        return this;
    }

    @Override
    public DnsSecurityRule refresh(Context context) {
        this.innerObject = (DnsSecurityRuleInner)((Object)this.serviceManager.serviceClient().getDnsSecurityRules().getWithResponse(this.resourceGroupName, this.dnsResolverPolicyName, this.dnsSecurityRuleName, context).getValue());
        return this;
    }

    @Override
    public DnsSecurityRuleImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public DnsSecurityRuleImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public DnsSecurityRuleImpl withPriority(int priority) {
        this.innerModel().withPriority(priority);
        return this;
    }

    @Override
    public DnsSecurityRuleImpl withAction(DnsSecurityRuleAction action) {
        if (this.isInCreateMode()) {
            this.innerModel().withAction(action);
            return this;
        }
        this.updateParameters.withAction(action);
        return this;
    }

    @Override
    public DnsSecurityRuleImpl withDnsResolverDomainLists(List<SubResource> dnsResolverDomainLists) {
        if (this.isInCreateMode()) {
            this.innerModel().withDnsResolverDomainLists(dnsResolverDomainLists);
            return this;
        }
        this.updateParameters.withDnsResolverDomainLists(dnsResolverDomainLists);
        return this;
    }

    @Override
    public DnsSecurityRuleImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateParameters.withTags(tags);
        return this;
    }

    @Override
    public DnsSecurityRuleImpl withDnsSecurityRuleState(DnsSecurityRuleState dnsSecurityRuleState) {
        if (this.isInCreateMode()) {
            this.innerModel().withDnsSecurityRuleState(dnsSecurityRuleState);
            return this;
        }
        this.updateParameters.withDnsSecurityRuleState(dnsSecurityRuleState);
        return this;
    }

    @Override
    public DnsSecurityRuleImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    @Override
    public DnsSecurityRuleImpl withIfNoneMatch(String ifNoneMatch) {
        this.createIfNoneMatch = ifNoneMatch;
        return this;
    }

    @Override
    public DnsSecurityRuleImpl withPriority(Integer priority) {
        this.updateParameters.withPriority(priority);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

