/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dnsresolver.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.dnsresolver.DnsResolverManager;
import com.azure.resourcemanager.dnsresolver.fluent.models.DnsResolverPolicyInner;
import com.azure.resourcemanager.dnsresolver.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.dnsresolver.models.DnsResolverPolicy;
import com.azure.resourcemanager.dnsresolver.models.DnsResolverPolicyPatch;
import com.azure.resourcemanager.dnsresolver.models.ProvisioningState;
import java.util.Collections;
import java.util.Map;

public final class DnsResolverPolicyImpl
implements DnsResolverPolicy,
DnsResolverPolicy.Definition,
DnsResolverPolicy.Update {
    private DnsResolverPolicyInner innerObject;
    private final DnsResolverManager serviceManager;
    private String resourceGroupName;
    private String dnsResolverPolicyName;
    private String createIfMatch;
    private String createIfNoneMatch;
    private String updateIfMatch;
    private DnsResolverPolicyPatch updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public ProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String resourceGuid() {
        return this.innerModel().resourceGuid();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public DnsResolverPolicyInner innerModel() {
        return this.innerObject;
    }

    private DnsResolverManager manager() {
        return this.serviceManager;
    }

    @Override
    public DnsResolverPolicyImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public DnsResolverPolicy create() {
        this.innerObject = this.serviceManager.serviceClient().getDnsResolverPolicies().createOrUpdate(this.resourceGroupName, this.dnsResolverPolicyName, this.innerModel(), this.createIfMatch, this.createIfNoneMatch, Context.NONE);
        return this;
    }

    @Override
    public DnsResolverPolicy create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getDnsResolverPolicies().createOrUpdate(this.resourceGroupName, this.dnsResolverPolicyName, this.innerModel(), this.createIfMatch, this.createIfNoneMatch, context);
        return this;
    }

    DnsResolverPolicyImpl(String name, DnsResolverManager serviceManager) {
        this.innerObject = new DnsResolverPolicyInner();
        this.serviceManager = serviceManager;
        this.dnsResolverPolicyName = name;
        this.createIfMatch = null;
        this.createIfNoneMatch = null;
    }

    @Override
    public DnsResolverPolicyImpl update() {
        this.updateIfMatch = null;
        this.updateParameters = new DnsResolverPolicyPatch();
        return this;
    }

    @Override
    public DnsResolverPolicy apply() {
        this.innerObject = this.serviceManager.serviceClient().getDnsResolverPolicies().update(this.resourceGroupName, this.dnsResolverPolicyName, this.updateParameters, this.updateIfMatch, Context.NONE);
        return this;
    }

    @Override
    public DnsResolverPolicy apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getDnsResolverPolicies().update(this.resourceGroupName, this.dnsResolverPolicyName, this.updateParameters, this.updateIfMatch, context);
        return this;
    }

    DnsResolverPolicyImpl(DnsResolverPolicyInner innerObject, DnsResolverManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.dnsResolverPolicyName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "dnsResolverPolicies");
    }

    @Override
    public DnsResolverPolicy refresh() {
        this.innerObject = (DnsResolverPolicyInner)((Object)this.serviceManager.serviceClient().getDnsResolverPolicies().getByResourceGroupWithResponse(this.resourceGroupName, this.dnsResolverPolicyName, Context.NONE).getValue());
        return this;
    }

    @Override
    public DnsResolverPolicy refresh(Context context) {
        this.innerObject = (DnsResolverPolicyInner)((Object)this.serviceManager.serviceClient().getDnsResolverPolicies().getByResourceGroupWithResponse(this.resourceGroupName, this.dnsResolverPolicyName, context).getValue());
        return this;
    }

    @Override
    public DnsResolverPolicyImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public DnsResolverPolicyImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public DnsResolverPolicyImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateParameters.withTags(tags);
        return this;
    }

    @Override
    public DnsResolverPolicyImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    @Override
    public DnsResolverPolicyImpl withIfNoneMatch(String ifNoneMatch) {
        this.createIfNoneMatch = ifNoneMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

