/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dnsresolver.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dnsresolver.models.ProvisioningState;
import java.io.IOException;
import java.util.Map;

public final class VirtualNetworkLinkProperties
implements JsonSerializable<VirtualNetworkLinkProperties> {
    private SubResource virtualNetwork;
    private Map<String, String> metadata;
    private ProvisioningState provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(VirtualNetworkLinkProperties.class);

    public SubResource virtualNetwork() {
        return this.virtualNetwork;
    }

    public VirtualNetworkLinkProperties withVirtualNetwork(SubResource virtualNetwork) {
        this.virtualNetwork = virtualNetwork;
        return this;
    }

    public Map<String, String> metadata() {
        return this.metadata;
    }

    public VirtualNetworkLinkProperties withMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.virtualNetwork() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property virtualNetwork in model VirtualNetworkLinkProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("virtualNetwork", (JsonSerializable)this.virtualNetwork);
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static VirtualNetworkLinkProperties fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualNetworkLinkProperties)jsonReader.readObject(reader -> {
            VirtualNetworkLinkProperties deserializedVirtualNetworkLinkProperties = new VirtualNetworkLinkProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("virtualNetwork".equals(fieldName)) {
                    deserializedVirtualNetworkLinkProperties.virtualNetwork = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    Map metadata;
                    deserializedVirtualNetworkLinkProperties.metadata = metadata = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedVirtualNetworkLinkProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualNetworkLinkProperties;
        });
    }
}

