/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dnsresolver.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dnsresolver.models.ProvisioningState;
import java.io.IOException;

public final class OutboundEndpointProperties
implements JsonSerializable<OutboundEndpointProperties> {
    private SubResource subnet;
    private ProvisioningState provisioningState;
    private String resourceGuid;
    private static final ClientLogger LOGGER = new ClientLogger(OutboundEndpointProperties.class);

    public SubResource subnet() {
        return this.subnet;
    }

    public OutboundEndpointProperties withSubnet(SubResource subnet) {
        this.subnet = subnet;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String resourceGuid() {
        return this.resourceGuid;
    }

    public void validate() {
        if (this.subnet() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property subnet in model OutboundEndpointProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("subnet", (JsonSerializable)this.subnet);
        return jsonWriter.writeEndObject();
    }

    public static OutboundEndpointProperties fromJson(JsonReader jsonReader) throws IOException {
        return (OutboundEndpointProperties)jsonReader.readObject(reader -> {
            OutboundEndpointProperties deserializedOutboundEndpointProperties = new OutboundEndpointProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("subnet".equals(fieldName)) {
                    deserializedOutboundEndpointProperties.subnet = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedOutboundEndpointProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("resourceGuid".equals(fieldName)) {
                    deserializedOutboundEndpointProperties.resourceGuid = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOutboundEndpointProperties;
        });
    }
}

