/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dnsresolver.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dnsresolver.models.IpConfiguration;
import com.azure.resourcemanager.dnsresolver.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class InboundEndpointProperties
implements JsonSerializable<InboundEndpointProperties> {
    private List<IpConfiguration> ipConfigurations;
    private ProvisioningState provisioningState;
    private String resourceGuid;
    private static final ClientLogger LOGGER = new ClientLogger(InboundEndpointProperties.class);

    public List<IpConfiguration> ipConfigurations() {
        return this.ipConfigurations;
    }

    public InboundEndpointProperties withIpConfigurations(List<IpConfiguration> ipConfigurations) {
        this.ipConfigurations = ipConfigurations;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String resourceGuid() {
        return this.resourceGuid;
    }

    public void validate() {
        if (this.ipConfigurations() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property ipConfigurations in model InboundEndpointProperties"));
        }
        this.ipConfigurations().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("ipConfigurations", this.ipConfigurations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static InboundEndpointProperties fromJson(JsonReader jsonReader) throws IOException {
        return (InboundEndpointProperties)jsonReader.readObject(reader -> {
            InboundEndpointProperties deserializedInboundEndpointProperties = new InboundEndpointProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("ipConfigurations".equals(fieldName)) {
                    List ipConfigurations;
                    deserializedInboundEndpointProperties.ipConfigurations = ipConfigurations = reader.readArray(reader1 -> IpConfiguration.fromJson(reader1));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedInboundEndpointProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("resourceGuid".equals(fieldName)) {
                    deserializedInboundEndpointProperties.resourceGuid = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedInboundEndpointProperties;
        });
    }
}

