/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dnsresolver.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dnsresolver.models.ForwardingRuleState;
import com.azure.resourcemanager.dnsresolver.models.ProvisioningState;
import com.azure.resourcemanager.dnsresolver.models.TargetDnsServer;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class ForwardingRuleProperties
implements JsonSerializable<ForwardingRuleProperties> {
    private String domainName;
    private List<TargetDnsServer> targetDnsServers;
    private Map<String, String> metadata;
    private ForwardingRuleState forwardingRuleState;
    private ProvisioningState provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(ForwardingRuleProperties.class);

    public String domainName() {
        return this.domainName;
    }

    public ForwardingRuleProperties withDomainName(String domainName) {
        this.domainName = domainName;
        return this;
    }

    public List<TargetDnsServer> targetDnsServers() {
        return this.targetDnsServers;
    }

    public ForwardingRuleProperties withTargetDnsServers(List<TargetDnsServer> targetDnsServers) {
        this.targetDnsServers = targetDnsServers;
        return this;
    }

    public Map<String, String> metadata() {
        return this.metadata;
    }

    public ForwardingRuleProperties withMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public ForwardingRuleState forwardingRuleState() {
        return this.forwardingRuleState;
    }

    public ForwardingRuleProperties withForwardingRuleState(ForwardingRuleState forwardingRuleState) {
        this.forwardingRuleState = forwardingRuleState;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.domainName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property domainName in model ForwardingRuleProperties"));
        }
        if (this.targetDnsServers() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property targetDnsServers in model ForwardingRuleProperties"));
        }
        this.targetDnsServers().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("domainName", this.domainName);
        jsonWriter.writeArrayField("targetDnsServers", this.targetDnsServers, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("forwardingRuleState", this.forwardingRuleState == null ? null : this.forwardingRuleState.toString());
        return jsonWriter.writeEndObject();
    }

    public static ForwardingRuleProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ForwardingRuleProperties)jsonReader.readObject(reader -> {
            ForwardingRuleProperties deserializedForwardingRuleProperties = new ForwardingRuleProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("domainName".equals(fieldName)) {
                    deserializedForwardingRuleProperties.domainName = reader.getString();
                    continue;
                }
                if ("targetDnsServers".equals(fieldName)) {
                    List targetDnsServers;
                    deserializedForwardingRuleProperties.targetDnsServers = targetDnsServers = reader.readArray(reader1 -> TargetDnsServer.fromJson(reader1));
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    Map metadata;
                    deserializedForwardingRuleProperties.metadata = metadata = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("forwardingRuleState".equals(fieldName)) {
                    deserializedForwardingRuleProperties.forwardingRuleState = ForwardingRuleState.fromString(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedForwardingRuleProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedForwardingRuleProperties;
        });
    }
}

