/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dnsresolver.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dnsresolver.fluent.models.ForwardingRuleProperties;
import com.azure.resourcemanager.dnsresolver.models.ForwardingRuleState;
import com.azure.resourcemanager.dnsresolver.models.ProvisioningState;
import com.azure.resourcemanager.dnsresolver.models.TargetDnsServer;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class ForwardingRuleInner
extends ProxyResource {
    private String etag;
    private ForwardingRuleProperties innerProperties = new ForwardingRuleProperties();
    private SystemData systemData;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(ForwardingRuleInner.class);

    public String etag() {
        return this.etag;
    }

    private ForwardingRuleProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String domainName() {
        return this.innerProperties() == null ? null : this.innerProperties().domainName();
    }

    public ForwardingRuleInner withDomainName(String domainName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ForwardingRuleProperties();
        }
        this.innerProperties().withDomainName(domainName);
        return this;
    }

    public List<TargetDnsServer> targetDnsServers() {
        return this.innerProperties() == null ? null : this.innerProperties().targetDnsServers();
    }

    public ForwardingRuleInner withTargetDnsServers(List<TargetDnsServer> targetDnsServers) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ForwardingRuleProperties();
        }
        this.innerProperties().withTargetDnsServers(targetDnsServers);
        return this;
    }

    public Map<String, String> metadata() {
        return this.innerProperties() == null ? null : this.innerProperties().metadata();
    }

    public ForwardingRuleInner withMetadata(Map<String, String> metadata) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ForwardingRuleProperties();
        }
        this.innerProperties().withMetadata(metadata);
        return this;
    }

    public ForwardingRuleState forwardingRuleState() {
        return this.innerProperties() == null ? null : this.innerProperties().forwardingRuleState();
    }

    public ForwardingRuleInner withForwardingRuleState(ForwardingRuleState forwardingRuleState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ForwardingRuleProperties();
        }
        this.innerProperties().withForwardingRuleState(forwardingRuleState);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model ForwardingRuleInner"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ForwardingRuleInner fromJson(JsonReader jsonReader) throws IOException {
        return (ForwardingRuleInner)((Object)jsonReader.readObject(reader -> {
            ForwardingRuleInner deserializedForwardingRuleInner = new ForwardingRuleInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedForwardingRuleInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedForwardingRuleInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedForwardingRuleInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedForwardingRuleInner.innerProperties = ForwardingRuleProperties.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedForwardingRuleInner.etag = reader.getString();
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedForwardingRuleInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedForwardingRuleInner;
        }));
    }
}

