/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dnsresolver.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dnsresolver.models.DnsSecurityRuleAction;
import com.azure.resourcemanager.dnsresolver.models.DnsSecurityRuleState;
import com.azure.resourcemanager.dnsresolver.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class DnsSecurityRuleProperties
implements JsonSerializable<DnsSecurityRuleProperties> {
    private int priority;
    private DnsSecurityRuleAction action;
    private List<SubResource> dnsResolverDomainLists;
    private DnsSecurityRuleState dnsSecurityRuleState;
    private ProvisioningState provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(DnsSecurityRuleProperties.class);

    public int priority() {
        return this.priority;
    }

    public DnsSecurityRuleProperties withPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public DnsSecurityRuleAction action() {
        return this.action;
    }

    public DnsSecurityRuleProperties withAction(DnsSecurityRuleAction action) {
        this.action = action;
        return this;
    }

    public List<SubResource> dnsResolverDomainLists() {
        return this.dnsResolverDomainLists;
    }

    public DnsSecurityRuleProperties withDnsResolverDomainLists(List<SubResource> dnsResolverDomainLists) {
        this.dnsResolverDomainLists = dnsResolverDomainLists;
        return this;
    }

    public DnsSecurityRuleState dnsSecurityRuleState() {
        return this.dnsSecurityRuleState;
    }

    public DnsSecurityRuleProperties withDnsSecurityRuleState(DnsSecurityRuleState dnsSecurityRuleState) {
        this.dnsSecurityRuleState = dnsSecurityRuleState;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.action() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property action in model DnsSecurityRuleProperties"));
        }
        this.action().validate();
        if (this.dnsResolverDomainLists() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property dnsResolverDomainLists in model DnsSecurityRuleProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("priority", this.priority);
        jsonWriter.writeJsonField("action", (JsonSerializable)this.action);
        jsonWriter.writeArrayField("dnsResolverDomainLists", this.dnsResolverDomainLists, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("dnsSecurityRuleState", this.dnsSecurityRuleState == null ? null : this.dnsSecurityRuleState.toString());
        return jsonWriter.writeEndObject();
    }

    public static DnsSecurityRuleProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DnsSecurityRuleProperties)jsonReader.readObject(reader -> {
            DnsSecurityRuleProperties deserializedDnsSecurityRuleProperties = new DnsSecurityRuleProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("priority".equals(fieldName)) {
                    deserializedDnsSecurityRuleProperties.priority = reader.getInt();
                    continue;
                }
                if ("action".equals(fieldName)) {
                    deserializedDnsSecurityRuleProperties.action = DnsSecurityRuleAction.fromJson(reader);
                    continue;
                }
                if ("dnsResolverDomainLists".equals(fieldName)) {
                    List dnsResolverDomainLists;
                    deserializedDnsSecurityRuleProperties.dnsResolverDomainLists = dnsResolverDomainLists = reader.readArray(reader1 -> SubResource.fromJson((JsonReader)reader1));
                    continue;
                }
                if ("dnsSecurityRuleState".equals(fieldName)) {
                    deserializedDnsSecurityRuleProperties.dnsSecurityRuleState = DnsSecurityRuleState.fromString(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedDnsSecurityRuleProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDnsSecurityRuleProperties;
        });
    }
}

