/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dnsresolver.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dnsresolver.models.DnsResolverState;
import com.azure.resourcemanager.dnsresolver.models.ProvisioningState;
import java.io.IOException;

public final class DnsResolverProperties
implements JsonSerializable<DnsResolverProperties> {
    private SubResource virtualNetwork;
    private DnsResolverState dnsResolverState;
    private ProvisioningState provisioningState;
    private String resourceGuid;
    private static final ClientLogger LOGGER = new ClientLogger(DnsResolverProperties.class);

    public SubResource virtualNetwork() {
        return this.virtualNetwork;
    }

    public DnsResolverProperties withVirtualNetwork(SubResource virtualNetwork) {
        this.virtualNetwork = virtualNetwork;
        return this;
    }

    public DnsResolverState dnsResolverState() {
        return this.dnsResolverState;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String resourceGuid() {
        return this.resourceGuid;
    }

    public void validate() {
        if (this.virtualNetwork() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property virtualNetwork in model DnsResolverProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("virtualNetwork", (JsonSerializable)this.virtualNetwork);
        return jsonWriter.writeEndObject();
    }

    public static DnsResolverProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DnsResolverProperties)jsonReader.readObject(reader -> {
            DnsResolverProperties deserializedDnsResolverProperties = new DnsResolverProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("virtualNetwork".equals(fieldName)) {
                    deserializedDnsResolverProperties.virtualNetwork = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("dnsResolverState".equals(fieldName)) {
                    deserializedDnsResolverProperties.dnsResolverState = DnsResolverState.fromString(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedDnsResolverProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("resourceGuid".equals(fieldName)) {
                    deserializedDnsResolverProperties.resourceGuid = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDnsResolverProperties;
        });
    }
}

