/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dnsresolver.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dnsresolver.fluent.models.DnsResolverDomainListProperties;
import com.azure.resourcemanager.dnsresolver.models.ProvisioningState;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class DnsResolverDomainListInner
extends Resource {
    private String etag;
    private DnsResolverDomainListProperties innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    public String etag() {
        return this.etag;
    }

    private DnsResolverDomainListProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public DnsResolverDomainListInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public DnsResolverDomainListInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public List<String> domains() {
        return this.innerProperties() == null ? null : this.innerProperties().domains();
    }

    public DnsResolverDomainListInner withDomains(List<String> domains) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DnsResolverDomainListProperties();
        }
        this.innerProperties().withDomains(domains);
        return this;
    }

    public String domainsUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().domainsUrl();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String resourceGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceGuid();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static DnsResolverDomainListInner fromJson(JsonReader jsonReader) throws IOException {
        return (DnsResolverDomainListInner)((Object)jsonReader.readObject(reader -> {
            DnsResolverDomainListInner deserializedDnsResolverDomainListInner = new DnsResolverDomainListInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDnsResolverDomainListInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDnsResolverDomainListInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDnsResolverDomainListInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedDnsResolverDomainListInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedDnsResolverDomainListInner.withTags(tags);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedDnsResolverDomainListInner.etag = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedDnsResolverDomainListInner.innerProperties = DnsResolverDomainListProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedDnsResolverDomainListInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDnsResolverDomainListInner;
        }));
    }
}

