/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dnsresolver.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dnsresolver.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class DnsForwardingRulesetProperties
implements JsonSerializable<DnsForwardingRulesetProperties> {
    private List<SubResource> dnsResolverOutboundEndpoints;
    private ProvisioningState provisioningState;
    private String resourceGuid;
    private static final ClientLogger LOGGER = new ClientLogger(DnsForwardingRulesetProperties.class);

    public List<SubResource> dnsResolverOutboundEndpoints() {
        return this.dnsResolverOutboundEndpoints;
    }

    public DnsForwardingRulesetProperties withDnsResolverOutboundEndpoints(List<SubResource> dnsResolverOutboundEndpoints) {
        this.dnsResolverOutboundEndpoints = dnsResolverOutboundEndpoints;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String resourceGuid() {
        return this.resourceGuid;
    }

    public void validate() {
        if (this.dnsResolverOutboundEndpoints() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property dnsResolverOutboundEndpoints in model DnsForwardingRulesetProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("dnsResolverOutboundEndpoints", this.dnsResolverOutboundEndpoints, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DnsForwardingRulesetProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DnsForwardingRulesetProperties)jsonReader.readObject(reader -> {
            DnsForwardingRulesetProperties deserializedDnsForwardingRulesetProperties = new DnsForwardingRulesetProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("dnsResolverOutboundEndpoints".equals(fieldName)) {
                    List dnsResolverOutboundEndpoints;
                    deserializedDnsForwardingRulesetProperties.dnsResolverOutboundEndpoints = dnsResolverOutboundEndpoints = reader.readArray(reader1 -> SubResource.fromJson((JsonReader)reader1));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedDnsForwardingRulesetProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("resourceGuid".equals(fieldName)) {
                    deserializedDnsForwardingRulesetProperties.resourceGuid = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDnsForwardingRulesetProperties;
        });
    }
}

