/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dnsresolver.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dnsresolver.fluent.models.DnsForwardingRulesetProperties;
import com.azure.resourcemanager.dnsresolver.models.ProvisioningState;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class DnsForwardingRulesetInner
extends Resource {
    private String etag;
    private DnsForwardingRulesetProperties innerProperties = new DnsForwardingRulesetProperties();
    private SystemData systemData;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(DnsForwardingRulesetInner.class);

    public String etag() {
        return this.etag;
    }

    private DnsForwardingRulesetProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public DnsForwardingRulesetInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public DnsForwardingRulesetInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public List<SubResource> dnsResolverOutboundEndpoints() {
        return this.innerProperties() == null ? null : this.innerProperties().dnsResolverOutboundEndpoints();
    }

    public DnsForwardingRulesetInner withDnsResolverOutboundEndpoints(List<SubResource> dnsResolverOutboundEndpoints) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DnsForwardingRulesetProperties();
        }
        this.innerProperties().withDnsResolverOutboundEndpoints(dnsResolverOutboundEndpoints);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String resourceGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceGuid();
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model DnsForwardingRulesetInner"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static DnsForwardingRulesetInner fromJson(JsonReader jsonReader) throws IOException {
        return (DnsForwardingRulesetInner)((Object)jsonReader.readObject(reader -> {
            DnsForwardingRulesetInner deserializedDnsForwardingRulesetInner = new DnsForwardingRulesetInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDnsForwardingRulesetInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDnsForwardingRulesetInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDnsForwardingRulesetInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedDnsForwardingRulesetInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedDnsForwardingRulesetInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedDnsForwardingRulesetInner.innerProperties = DnsForwardingRulesetProperties.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedDnsForwardingRulesetInner.etag = reader.getString();
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedDnsForwardingRulesetInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDnsForwardingRulesetInner;
        }));
    }
}

