// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.dns.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.dns.fluent.models.DnsResourceReferenceRequestProperties;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Represents the properties of the Dns Resource Reference Request. */
@Fluent
public final class DnsResourceReferenceRequest {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(DnsResourceReferenceRequest.class);

    /*
     * The properties of the Resource Reference Request.
     */
    @JsonProperty(value = "properties")
    private DnsResourceReferenceRequestProperties innerProperties;

    /**
     * Get the innerProperties property: The properties of the Resource Reference Request.
     *
     * @return the innerProperties value.
     */
    private DnsResourceReferenceRequestProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the targetResources property: A list of references to azure resources for which referencing dns records need
     * to be queried.
     *
     * @return the targetResources value.
     */
    public List<SubResource> targetResources() {
        return this.innerProperties() == null ? null : this.innerProperties().targetResources();
    }

    /**
     * Set the targetResources property: A list of references to azure resources for which referencing dns records need
     * to be queried.
     *
     * @param targetResources the targetResources value to set.
     * @return the DnsResourceReferenceRequest object itself.
     */
    public DnsResourceReferenceRequest withTargetResources(List<SubResource> targetResources) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DnsResourceReferenceRequestProperties();
        }
        this.innerProperties().withTargetResources(targetResources);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
