/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dependencymap.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dependencymap.models.DiscoverySourceResourceProperties;
import com.azure.resourcemanager.dependencymap.models.ProvisioningState;
import com.azure.resourcemanager.dependencymap.models.SourceType;
import java.io.IOException;

public final class OffAzureDiscoverySourceResourceProperties
extends DiscoverySourceResourceProperties {
    private SourceType sourceType = SourceType.OFF_AZURE;
    private static final ClientLogger LOGGER = new ClientLogger(OffAzureDiscoverySourceResourceProperties.class);

    @Override
    public SourceType sourceType() {
        return this.sourceType;
    }

    @Override
    public OffAzureDiscoverySourceResourceProperties withSourceId(String sourceId) {
        super.withSourceId(sourceId);
        return this;
    }

    @Override
    public void validate() {
        if (this.sourceId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sourceId in model OffAzureDiscoverySourceResourceProperties"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sourceId", this.sourceId());
        jsonWriter.writeStringField("sourceType", this.sourceType == null ? null : this.sourceType.toString());
        return jsonWriter.writeEndObject();
    }

    public static OffAzureDiscoverySourceResourceProperties fromJson(JsonReader jsonReader) throws IOException {
        return (OffAzureDiscoverySourceResourceProperties)jsonReader.readObject(reader -> {
            OffAzureDiscoverySourceResourceProperties deserializedOffAzureDiscoverySourceResourceProperties = new OffAzureDiscoverySourceResourceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceId".equals(fieldName)) {
                    deserializedOffAzureDiscoverySourceResourceProperties.withSourceId(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedOffAzureDiscoverySourceResourceProperties.withProvisioningState(ProvisioningState.fromString(reader.getString()));
                    continue;
                }
                if ("sourceType".equals(fieldName)) {
                    deserializedOffAzureDiscoverySourceResourceProperties.sourceType = SourceType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOffAzureDiscoverySourceResourceProperties;
        });
    }
}

