/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dependencymap.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.dependencymap.fluent.models.MapsResourceInner;
import com.azure.resourcemanager.dependencymap.models.ExportDependenciesRequest;
import com.azure.resourcemanager.dependencymap.models.GetConnectionsForProcessOnFocusedMachineRequest;
import com.azure.resourcemanager.dependencymap.models.GetConnectionsWithConnectedMachineForFocusedMachineRequest;
import com.azure.resourcemanager.dependencymap.models.GetDependencyViewForFocusedMachineRequest;
import com.azure.resourcemanager.dependencymap.models.MapsResourceProperties;
import java.util.Map;

public interface MapsResource {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public MapsResourceProperties properties();

    public SystemData systemData();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public MapsResourceInner innerModel();

    public Update update();

    public MapsResource refresh();

    public MapsResource refresh(Context var1);

    public void getDependencyViewForFocusedMachine(GetDependencyViewForFocusedMachineRequest var1);

    public void getDependencyViewForFocusedMachine(GetDependencyViewForFocusedMachineRequest var1, Context var2);

    public void getConnectionsWithConnectedMachineForFocusedMachine(GetConnectionsWithConnectedMachineForFocusedMachineRequest var1);

    public void getConnectionsWithConnectedMachineForFocusedMachine(GetConnectionsWithConnectedMachineForFocusedMachineRequest var1, Context var2);

    public void getConnectionsForProcessOnFocusedMachine(GetConnectionsForProcessOnFocusedMachineRequest var1);

    public void getConnectionsForProcessOnFocusedMachine(GetConnectionsForProcessOnFocusedMachineRequest var1, Context var2);

    public void exportDependencies(ExportDependenciesRequest var1);

    public void exportDependencies(ExportDependenciesRequest var1, Context var2);

    public static interface UpdateStages {

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags {
        public MapsResource apply();

        public MapsResource apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithProperties {
            public WithCreate withProperties(MapsResourceProperties var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithProperties {
            public MapsResource create();

            public MapsResource create(Context var1);
        }

        public static interface WithResourceGroup {
            public WithCreate withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithCreate {
    }
}

