/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dependencymap.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dependencymap.models.DependencyMapVisualizationFilter;
import java.io.IOException;

public final class GetDependencyViewForFocusedMachineRequest
implements JsonSerializable<GetDependencyViewForFocusedMachineRequest> {
    private String focusedMachineId;
    private DependencyMapVisualizationFilter filters;
    private static final ClientLogger LOGGER = new ClientLogger(GetDependencyViewForFocusedMachineRequest.class);

    public String focusedMachineId() {
        return this.focusedMachineId;
    }

    public GetDependencyViewForFocusedMachineRequest withFocusedMachineId(String focusedMachineId) {
        this.focusedMachineId = focusedMachineId;
        return this;
    }

    public DependencyMapVisualizationFilter filters() {
        return this.filters;
    }

    public GetDependencyViewForFocusedMachineRequest withFilters(DependencyMapVisualizationFilter filters) {
        this.filters = filters;
        return this;
    }

    public void validate() {
        if (this.focusedMachineId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property focusedMachineId in model GetDependencyViewForFocusedMachineRequest"));
        }
        if (this.filters() != null) {
            this.filters().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("focusedMachineId", this.focusedMachineId);
        jsonWriter.writeJsonField("filters", (JsonSerializable)this.filters);
        return jsonWriter.writeEndObject();
    }

    public static GetDependencyViewForFocusedMachineRequest fromJson(JsonReader jsonReader) throws IOException {
        return (GetDependencyViewForFocusedMachineRequest)jsonReader.readObject(reader -> {
            GetDependencyViewForFocusedMachineRequest deserializedGetDependencyViewForFocusedMachineRequest = new GetDependencyViewForFocusedMachineRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("focusedMachineId".equals(fieldName)) {
                    deserializedGetDependencyViewForFocusedMachineRequest.focusedMachineId = reader.getString();
                    continue;
                }
                if ("filters".equals(fieldName)) {
                    deserializedGetDependencyViewForFocusedMachineRequest.filters = DependencyMapVisualizationFilter.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGetDependencyViewForFocusedMachineRequest;
        });
    }
}

