/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dependencymap.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dependencymap.models.DependencyMapVisualizationFilter;
import java.io.IOException;

public final class GetConnectionsWithConnectedMachineForFocusedMachineRequest
implements JsonSerializable<GetConnectionsWithConnectedMachineForFocusedMachineRequest> {
    private String focusedMachineId;
    private String connectedMachineId;
    private DependencyMapVisualizationFilter filters;
    private static final ClientLogger LOGGER = new ClientLogger(GetConnectionsWithConnectedMachineForFocusedMachineRequest.class);

    public String focusedMachineId() {
        return this.focusedMachineId;
    }

    public GetConnectionsWithConnectedMachineForFocusedMachineRequest withFocusedMachineId(String focusedMachineId) {
        this.focusedMachineId = focusedMachineId;
        return this;
    }

    public String connectedMachineId() {
        return this.connectedMachineId;
    }

    public GetConnectionsWithConnectedMachineForFocusedMachineRequest withConnectedMachineId(String connectedMachineId) {
        this.connectedMachineId = connectedMachineId;
        return this;
    }

    public DependencyMapVisualizationFilter filters() {
        return this.filters;
    }

    public GetConnectionsWithConnectedMachineForFocusedMachineRequest withFilters(DependencyMapVisualizationFilter filters) {
        this.filters = filters;
        return this;
    }

    public void validate() {
        if (this.focusedMachineId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property focusedMachineId in model GetConnectionsWithConnectedMachineForFocusedMachineRequest"));
        }
        if (this.connectedMachineId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property connectedMachineId in model GetConnectionsWithConnectedMachineForFocusedMachineRequest"));
        }
        if (this.filters() != null) {
            this.filters().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("focusedMachineId", this.focusedMachineId);
        jsonWriter.writeStringField("connectedMachineId", this.connectedMachineId);
        jsonWriter.writeJsonField("filters", (JsonSerializable)this.filters);
        return jsonWriter.writeEndObject();
    }

    public static GetConnectionsWithConnectedMachineForFocusedMachineRequest fromJson(JsonReader jsonReader) throws IOException {
        return (GetConnectionsWithConnectedMachineForFocusedMachineRequest)jsonReader.readObject(reader -> {
            GetConnectionsWithConnectedMachineForFocusedMachineRequest deserializedGetConnectionsWithConnectedMachineForFocusedMachineRequest = new GetConnectionsWithConnectedMachineForFocusedMachineRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("focusedMachineId".equals(fieldName)) {
                    deserializedGetConnectionsWithConnectedMachineForFocusedMachineRequest.focusedMachineId = reader.getString();
                    continue;
                }
                if ("connectedMachineId".equals(fieldName)) {
                    deserializedGetConnectionsWithConnectedMachineForFocusedMachineRequest.connectedMachineId = reader.getString();
                    continue;
                }
                if ("filters".equals(fieldName)) {
                    deserializedGetConnectionsWithConnectedMachineForFocusedMachineRequest.filters = DependencyMapVisualizationFilter.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGetConnectionsWithConnectedMachineForFocusedMachineRequest;
        });
    }
}

