/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dependencymap.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dependencymap.models.DependencyMapVisualizationFilter;
import java.io.IOException;

public final class ExportDependenciesRequest
implements JsonSerializable<ExportDependenciesRequest> {
    private String focusedMachineId;
    private DependencyMapVisualizationFilter filters;
    private static final ClientLogger LOGGER = new ClientLogger(ExportDependenciesRequest.class);

    public String focusedMachineId() {
        return this.focusedMachineId;
    }

    public ExportDependenciesRequest withFocusedMachineId(String focusedMachineId) {
        this.focusedMachineId = focusedMachineId;
        return this;
    }

    public DependencyMapVisualizationFilter filters() {
        return this.filters;
    }

    public ExportDependenciesRequest withFilters(DependencyMapVisualizationFilter filters) {
        this.filters = filters;
        return this;
    }

    public void validate() {
        if (this.focusedMachineId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property focusedMachineId in model ExportDependenciesRequest"));
        }
        if (this.filters() != null) {
            this.filters().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("focusedMachineId", this.focusedMachineId);
        jsonWriter.writeJsonField("filters", (JsonSerializable)this.filters);
        return jsonWriter.writeEndObject();
    }

    public static ExportDependenciesRequest fromJson(JsonReader jsonReader) throws IOException {
        return (ExportDependenciesRequest)jsonReader.readObject(reader -> {
            ExportDependenciesRequest deserializedExportDependenciesRequest = new ExportDependenciesRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("focusedMachineId".equals(fieldName)) {
                    deserializedExportDependenciesRequest.focusedMachineId = reader.getString();
                    continue;
                }
                if ("filters".equals(fieldName)) {
                    deserializedExportDependenciesRequest.filters = DependencyMapVisualizationFilter.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExportDependenciesRequest;
        });
    }
}

