/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dependencymap.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dependencymap.models.OffAzureDiscoverySourceResourceProperties;
import com.azure.resourcemanager.dependencymap.models.ProvisioningState;
import com.azure.resourcemanager.dependencymap.models.SourceType;
import java.io.IOException;

public class DiscoverySourceResourceProperties
implements JsonSerializable<DiscoverySourceResourceProperties> {
    private SourceType sourceType = SourceType.fromString("DiscoverySourceResourceProperties");
    private ProvisioningState provisioningState;
    private String sourceId;
    private static final ClientLogger LOGGER = new ClientLogger(DiscoverySourceResourceProperties.class);

    public SourceType sourceType() {
        return this.sourceType;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    DiscoverySourceResourceProperties withProvisioningState(ProvisioningState provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    public String sourceId() {
        return this.sourceId;
    }

    public DiscoverySourceResourceProperties withSourceId(String sourceId) {
        this.sourceId = sourceId;
        return this;
    }

    public void validate() {
        if (this.sourceId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sourceId in model DiscoverySourceResourceProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sourceId", this.sourceId);
        jsonWriter.writeStringField("sourceType", this.sourceType == null ? null : this.sourceType.toString());
        return jsonWriter.writeEndObject();
    }

    public static DiscoverySourceResourceProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DiscoverySourceResourceProperties)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                DiscoverySourceResourceProperties discoverySourceResourceProperties;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("sourceType".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("OffAzure".equals(discriminatorValue)) {
                    discoverySourceResourceProperties = OffAzureDiscoverySourceResourceProperties.fromJson(readerToUse.reset());
                    return discoverySourceResourceProperties;
                }
                discoverySourceResourceProperties = DiscoverySourceResourceProperties.fromJsonKnownDiscriminator(readerToUse.reset());
                return discoverySourceResourceProperties;
            }
        });
    }

    static DiscoverySourceResourceProperties fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (DiscoverySourceResourceProperties)jsonReader.readObject(reader -> {
            DiscoverySourceResourceProperties deserializedDiscoverySourceResourceProperties = new DiscoverySourceResourceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceId".equals(fieldName)) {
                    deserializedDiscoverySourceResourceProperties.sourceId = reader.getString();
                    continue;
                }
                if ("sourceType".equals(fieldName)) {
                    deserializedDiscoverySourceResourceProperties.sourceType = SourceType.fromString(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedDiscoverySourceResourceProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDiscoverySourceResourceProperties;
        });
    }
}

