/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dependencymap.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dependencymap.models.DateTimeFilter;
import com.azure.resourcemanager.dependencymap.models.ProcessNameFilter;
import java.io.IOException;

public final class DependencyMapVisualizationFilter
implements JsonSerializable<DependencyMapVisualizationFilter> {
    private DateTimeFilter dateTime;
    private ProcessNameFilter processNameFilter;

    public DateTimeFilter dateTime() {
        return this.dateTime;
    }

    public DependencyMapVisualizationFilter withDateTime(DateTimeFilter dateTime) {
        this.dateTime = dateTime;
        return this;
    }

    public ProcessNameFilter processNameFilter() {
        return this.processNameFilter;
    }

    public DependencyMapVisualizationFilter withProcessNameFilter(ProcessNameFilter processNameFilter) {
        this.processNameFilter = processNameFilter;
        return this;
    }

    public void validate() {
        if (this.dateTime() != null) {
            this.dateTime().validate();
        }
        if (this.processNameFilter() != null) {
            this.processNameFilter().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("dateTime", (JsonSerializable)this.dateTime);
        jsonWriter.writeJsonField("processNameFilter", (JsonSerializable)this.processNameFilter);
        return jsonWriter.writeEndObject();
    }

    public static DependencyMapVisualizationFilter fromJson(JsonReader jsonReader) throws IOException {
        return (DependencyMapVisualizationFilter)jsonReader.readObject(reader -> {
            DependencyMapVisualizationFilter deserializedDependencyMapVisualizationFilter = new DependencyMapVisualizationFilter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("dateTime".equals(fieldName)) {
                    deserializedDependencyMapVisualizationFilter.dateTime = DateTimeFilter.fromJson(reader);
                    continue;
                }
                if ("processNameFilter".equals(fieldName)) {
                    deserializedDependencyMapVisualizationFilter.processNameFilter = ProcessNameFilter.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDependencyMapVisualizationFilter;
        });
    }
}

