/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dependencymap.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dependencymap.fluent.models.MapsResourceInner;
import java.io.IOException;
import java.util.List;

public final class MapsResourceListResult
implements JsonSerializable<MapsResourceListResult> {
    private List<MapsResourceInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(MapsResourceListResult.class);

    private MapsResourceListResult() {
    }

    public List<MapsResourceInner> value() {
        return this.value;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model MapsResourceListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static MapsResourceListResult fromJson(JsonReader jsonReader) throws IOException {
        return (MapsResourceListResult)jsonReader.readObject(reader -> {
            MapsResourceListResult deserializedMapsResourceListResult = new MapsResourceListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedMapsResourceListResult.value = value = reader.readArray(reader1 -> MapsResourceInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedMapsResourceListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMapsResourceListResult;
        });
    }
}

