/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dependencymap.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dependencymap.fluent.models.DiscoverySourceResourceInner;
import java.io.IOException;
import java.util.List;

public final class DiscoverySourceResourceListResult
implements JsonSerializable<DiscoverySourceResourceListResult> {
    private List<DiscoverySourceResourceInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(DiscoverySourceResourceListResult.class);

    private DiscoverySourceResourceListResult() {
    }

    public List<DiscoverySourceResourceInner> value() {
        return this.value;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model DiscoverySourceResourceListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static DiscoverySourceResourceListResult fromJson(JsonReader jsonReader) throws IOException {
        return (DiscoverySourceResourceListResult)jsonReader.readObject(reader -> {
            DiscoverySourceResourceListResult deserializedDiscoverySourceResourceListResult = new DiscoverySourceResourceListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedDiscoverySourceResourceListResult.value = value = reader.readArray(reader1 -> DiscoverySourceResourceInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedDiscoverySourceResourceListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDiscoverySourceResourceListResult;
        });
    }
}

