/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dependencymap.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.dependencymap.DependencyMapManager;
import com.azure.resourcemanager.dependencymap.fluent.models.MapsResourceInner;
import com.azure.resourcemanager.dependencymap.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.dependencymap.models.ExportDependenciesRequest;
import com.azure.resourcemanager.dependencymap.models.GetConnectionsForProcessOnFocusedMachineRequest;
import com.azure.resourcemanager.dependencymap.models.GetConnectionsWithConnectedMachineForFocusedMachineRequest;
import com.azure.resourcemanager.dependencymap.models.GetDependencyViewForFocusedMachineRequest;
import com.azure.resourcemanager.dependencymap.models.MapsResource;
import com.azure.resourcemanager.dependencymap.models.MapsResourceProperties;
import com.azure.resourcemanager.dependencymap.models.MapsResourceTagsUpdate;
import java.util.Collections;
import java.util.Map;

public final class MapsResourceImpl
implements MapsResource,
MapsResource.Definition,
MapsResource.Update {
    private MapsResourceInner innerObject;
    private final DependencyMapManager serviceManager;
    private String resourceGroupName;
    private String mapName;
    private MapsResourceTagsUpdate updateProperties;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public MapsResourceProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public MapsResourceInner innerModel() {
        return this.innerObject;
    }

    private DependencyMapManager manager() {
        return this.serviceManager;
    }

    @Override
    public MapsResourceImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public MapsResource create() {
        this.innerObject = this.serviceManager.serviceClient().getMaps().createOrUpdate(this.resourceGroupName, this.mapName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public MapsResource create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getMaps().createOrUpdate(this.resourceGroupName, this.mapName, this.innerModel(), context);
        return this;
    }

    MapsResourceImpl(String name, DependencyMapManager serviceManager) {
        this.innerObject = new MapsResourceInner();
        this.serviceManager = serviceManager;
        this.mapName = name;
    }

    @Override
    public MapsResourceImpl update() {
        this.updateProperties = new MapsResourceTagsUpdate();
        return this;
    }

    @Override
    public MapsResource apply() {
        this.innerObject = this.serviceManager.serviceClient().getMaps().update(this.resourceGroupName, this.mapName, this.updateProperties, Context.NONE);
        return this;
    }

    @Override
    public MapsResource apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getMaps().update(this.resourceGroupName, this.mapName, this.updateProperties, context);
        return this;
    }

    MapsResourceImpl(MapsResourceInner innerObject, DependencyMapManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.mapName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "maps");
    }

    @Override
    public MapsResource refresh() {
        this.innerObject = (MapsResourceInner)((Object)this.serviceManager.serviceClient().getMaps().getByResourceGroupWithResponse(this.resourceGroupName, this.mapName, Context.NONE).getValue());
        return this;
    }

    @Override
    public MapsResource refresh(Context context) {
        this.innerObject = (MapsResourceInner)((Object)this.serviceManager.serviceClient().getMaps().getByResourceGroupWithResponse(this.resourceGroupName, this.mapName, context).getValue());
        return this;
    }

    @Override
    public void getDependencyViewForFocusedMachine(GetDependencyViewForFocusedMachineRequest body) {
        this.serviceManager.maps().getDependencyViewForFocusedMachine(this.resourceGroupName, this.mapName, body);
    }

    @Override
    public void getDependencyViewForFocusedMachine(GetDependencyViewForFocusedMachineRequest body, Context context) {
        this.serviceManager.maps().getDependencyViewForFocusedMachine(this.resourceGroupName, this.mapName, body, context);
    }

    @Override
    public void getConnectionsWithConnectedMachineForFocusedMachine(GetConnectionsWithConnectedMachineForFocusedMachineRequest body) {
        this.serviceManager.maps().getConnectionsWithConnectedMachineForFocusedMachine(this.resourceGroupName, this.mapName, body);
    }

    @Override
    public void getConnectionsWithConnectedMachineForFocusedMachine(GetConnectionsWithConnectedMachineForFocusedMachineRequest body, Context context) {
        this.serviceManager.maps().getConnectionsWithConnectedMachineForFocusedMachine(this.resourceGroupName, this.mapName, body, context);
    }

    @Override
    public void getConnectionsForProcessOnFocusedMachine(GetConnectionsForProcessOnFocusedMachineRequest body) {
        this.serviceManager.maps().getConnectionsForProcessOnFocusedMachine(this.resourceGroupName, this.mapName, body);
    }

    @Override
    public void getConnectionsForProcessOnFocusedMachine(GetConnectionsForProcessOnFocusedMachineRequest body, Context context) {
        this.serviceManager.maps().getConnectionsForProcessOnFocusedMachine(this.resourceGroupName, this.mapName, body, context);
    }

    @Override
    public void exportDependencies(ExportDependenciesRequest body) {
        this.serviceManager.maps().exportDependencies(this.resourceGroupName, this.mapName, body);
    }

    @Override
    public void exportDependencies(ExportDependenciesRequest body, Context context) {
        this.serviceManager.maps().exportDependencies(this.resourceGroupName, this.mapName, body, context);
    }

    @Override
    public MapsResourceImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public MapsResourceImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public MapsResourceImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateProperties.withTags(tags);
        return this;
    }

    @Override
    public MapsResourceImpl withProperties(MapsResourceProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

