/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dependencymap.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.dependencymap.DependencyMapManager;
import com.azure.resourcemanager.dependencymap.fluent.MapsClient;
import com.azure.resourcemanager.dependencymap.fluent.models.MapsResourceInner;
import com.azure.resourcemanager.dependencymap.implementation.MapsResourceImpl;
import com.azure.resourcemanager.dependencymap.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.dependencymap.models.ExportDependenciesRequest;
import com.azure.resourcemanager.dependencymap.models.GetConnectionsForProcessOnFocusedMachineRequest;
import com.azure.resourcemanager.dependencymap.models.GetConnectionsWithConnectedMachineForFocusedMachineRequest;
import com.azure.resourcemanager.dependencymap.models.GetDependencyViewForFocusedMachineRequest;
import com.azure.resourcemanager.dependencymap.models.Maps;
import com.azure.resourcemanager.dependencymap.models.MapsResource;

public final class MapsImpl
implements Maps {
    private static final ClientLogger LOGGER = new ClientLogger(MapsImpl.class);
    private final MapsClient innerClient;
    private final DependencyMapManager serviceManager;

    public MapsImpl(MapsClient innerClient, DependencyMapManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<MapsResource> getByResourceGroupWithResponse(String resourceGroupName, String mapName, Context context) {
        Response<MapsResourceInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, mapName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new MapsResourceImpl((MapsResourceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public MapsResource getByResourceGroup(String resourceGroupName, String mapName) {
        MapsResourceInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, mapName);
        if (inner != null) {
            return new MapsResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String mapName) {
        this.serviceClient().delete(resourceGroupName, mapName);
    }

    @Override
    public void delete(String resourceGroupName, String mapName, Context context) {
        this.serviceClient().delete(resourceGroupName, mapName, context);
    }

    @Override
    public PagedIterable<MapsResource> listByResourceGroup(String resourceGroupName) {
        PagedIterable<MapsResourceInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new MapsResourceImpl((MapsResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<MapsResource> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<MapsResourceInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new MapsResourceImpl((MapsResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<MapsResource> list() {
        PagedIterable<MapsResourceInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new MapsResourceImpl((MapsResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<MapsResource> list(Context context) {
        PagedIterable<MapsResourceInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new MapsResourceImpl((MapsResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public void getDependencyViewForFocusedMachine(String resourceGroupName, String mapName, GetDependencyViewForFocusedMachineRequest body) {
        this.serviceClient().getDependencyViewForFocusedMachine(resourceGroupName, mapName, body);
    }

    @Override
    public void getDependencyViewForFocusedMachine(String resourceGroupName, String mapName, GetDependencyViewForFocusedMachineRequest body, Context context) {
        this.serviceClient().getDependencyViewForFocusedMachine(resourceGroupName, mapName, body, context);
    }

    @Override
    public void getConnectionsWithConnectedMachineForFocusedMachine(String resourceGroupName, String mapName, GetConnectionsWithConnectedMachineForFocusedMachineRequest body) {
        this.serviceClient().getConnectionsWithConnectedMachineForFocusedMachine(resourceGroupName, mapName, body);
    }

    @Override
    public void getConnectionsWithConnectedMachineForFocusedMachine(String resourceGroupName, String mapName, GetConnectionsWithConnectedMachineForFocusedMachineRequest body, Context context) {
        this.serviceClient().getConnectionsWithConnectedMachineForFocusedMachine(resourceGroupName, mapName, body, context);
    }

    @Override
    public void getConnectionsForProcessOnFocusedMachine(String resourceGroupName, String mapName, GetConnectionsForProcessOnFocusedMachineRequest body) {
        this.serviceClient().getConnectionsForProcessOnFocusedMachine(resourceGroupName, mapName, body);
    }

    @Override
    public void getConnectionsForProcessOnFocusedMachine(String resourceGroupName, String mapName, GetConnectionsForProcessOnFocusedMachineRequest body, Context context) {
        this.serviceClient().getConnectionsForProcessOnFocusedMachine(resourceGroupName, mapName, body, context);
    }

    @Override
    public void exportDependencies(String resourceGroupName, String mapName, ExportDependenciesRequest body) {
        this.serviceClient().exportDependencies(resourceGroupName, mapName, body);
    }

    @Override
    public void exportDependencies(String resourceGroupName, String mapName, ExportDependenciesRequest body, Context context) {
        this.serviceClient().exportDependencies(resourceGroupName, mapName, body, context);
    }

    @Override
    public MapsResource getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String mapName = ResourceManagerUtils.getValueFromIdByName(id, "maps");
        if (mapName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'maps'.", id)));
        }
        return (MapsResource)this.getByResourceGroupWithResponse(resourceGroupName, mapName, Context.NONE).getValue();
    }

    @Override
    public Response<MapsResource> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String mapName = ResourceManagerUtils.getValueFromIdByName(id, "maps");
        if (mapName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'maps'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, mapName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String mapName = ResourceManagerUtils.getValueFromIdByName(id, "maps");
        if (mapName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'maps'.", id)));
        }
        this.delete(resourceGroupName, mapName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String mapName = ResourceManagerUtils.getValueFromIdByName(id, "maps");
        if (mapName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'maps'.", id)));
        }
        this.delete(resourceGroupName, mapName, context);
    }

    private MapsClient serviceClient() {
        return this.innerClient;
    }

    private DependencyMapManager manager() {
        return this.serviceManager;
    }

    @Override
    public MapsResourceImpl define(String name) {
        return new MapsResourceImpl(name, this.manager());
    }
}

