/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dependencymap.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.dependencymap.fluent.MapsClient;
import com.azure.resourcemanager.dependencymap.fluent.models.MapsResourceInner;
import com.azure.resourcemanager.dependencymap.implementation.DependencyMapManagementClientImpl;
import com.azure.resourcemanager.dependencymap.implementation.models.MapsResourceListResult;
import com.azure.resourcemanager.dependencymap.models.ExportDependenciesRequest;
import com.azure.resourcemanager.dependencymap.models.GetConnectionsForProcessOnFocusedMachineRequest;
import com.azure.resourcemanager.dependencymap.models.GetConnectionsWithConnectedMachineForFocusedMachineRequest;
import com.azure.resourcemanager.dependencymap.models.GetDependencyViewForFocusedMachineRequest;
import com.azure.resourcemanager.dependencymap.models.MapsResourceTagsUpdate;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class MapsClientImpl
implements MapsClient {
    private final MapsService service;
    private final DependencyMapManagementClientImpl client;

    MapsClientImpl(DependencyMapManagementClientImpl client) {
        this.service = (MapsService)RestProxy.create(MapsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MapsResourceInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String mapName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (mapName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter mapName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getByResourceGroup(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, mapName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MapsResourceInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String mapName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (mapName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter mapName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getByResourceGroup(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, mapName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<MapsResourceInner> getByResourceGroupAsync(String resourceGroupName, String mapName) {
        return this.getByResourceGroupWithResponseAsync(resourceGroupName, mapName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((MapsResourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MapsResourceInner> getByResourceGroupWithResponse(String resourceGroupName, String mapName, Context context) {
        return (Response)this.getByResourceGroupWithResponseAsync(resourceGroupName, mapName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MapsResourceInner getByResourceGroup(String resourceGroupName, String mapName) {
        return (MapsResourceInner)((Object)this.getByResourceGroupWithResponse(resourceGroupName, mapName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String mapName, MapsResourceInner resource) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (mapName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter mapName is required and cannot be null."));
        }
        if (resource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resource is required and cannot be null."));
        }
        resource.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, mapName, "application/json", "application/json", resource, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String mapName, MapsResourceInner resource, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (mapName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter mapName is required and cannot be null."));
        }
        if (resource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resource is required and cannot be null."));
        }
        resource.validate();
        String contentType = "application/json";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, mapName, "application/json", "application/json", resource, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<MapsResourceInner>, MapsResourceInner> beginCreateOrUpdateAsync(String resourceGroupName, String mapName, MapsResourceInner resource) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, mapName, resource);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)MapsResourceInner.class), (Type)((Object)MapsResourceInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<MapsResourceInner>, MapsResourceInner> beginCreateOrUpdateAsync(String resourceGroupName, String mapName, MapsResourceInner resource, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, mapName, resource, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)MapsResourceInner.class), (Type)((Object)MapsResourceInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<MapsResourceInner>, MapsResourceInner> beginCreateOrUpdate(String resourceGroupName, String mapName, MapsResourceInner resource) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, mapName, resource).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<MapsResourceInner>, MapsResourceInner> beginCreateOrUpdate(String resourceGroupName, String mapName, MapsResourceInner resource, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, mapName, resource, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<MapsResourceInner> createOrUpdateAsync(String resourceGroupName, String mapName, MapsResourceInner resource) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, mapName, resource).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<MapsResourceInner> createOrUpdateAsync(String resourceGroupName, String mapName, MapsResourceInner resource, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, mapName, resource, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MapsResourceInner createOrUpdate(String resourceGroupName, String mapName, MapsResourceInner resource) {
        return (MapsResourceInner)((Object)this.createOrUpdateAsync(resourceGroupName, mapName, resource).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MapsResourceInner createOrUpdate(String resourceGroupName, String mapName, MapsResourceInner resource, Context context) {
        return (MapsResourceInner)((Object)this.createOrUpdateAsync(resourceGroupName, mapName, resource, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String mapName, MapsResourceTagsUpdate properties) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (mapName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter mapName is required and cannot be null."));
        }
        if (properties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter properties is required and cannot be null."));
        }
        properties.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, mapName, "application/json", "application/json", properties, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String mapName, MapsResourceTagsUpdate properties, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (mapName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter mapName is required and cannot be null."));
        }
        if (properties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter properties is required and cannot be null."));
        }
        properties.validate();
        String contentType = "application/json";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, mapName, "application/json", "application/json", properties, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<MapsResourceInner>, MapsResourceInner> beginUpdateAsync(String resourceGroupName, String mapName, MapsResourceTagsUpdate properties) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, mapName, properties);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)MapsResourceInner.class), (Type)((Object)MapsResourceInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<MapsResourceInner>, MapsResourceInner> beginUpdateAsync(String resourceGroupName, String mapName, MapsResourceTagsUpdate properties, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, mapName, properties, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)MapsResourceInner.class), (Type)((Object)MapsResourceInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<MapsResourceInner>, MapsResourceInner> beginUpdate(String resourceGroupName, String mapName, MapsResourceTagsUpdate properties) {
        return this.beginUpdateAsync(resourceGroupName, mapName, properties).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<MapsResourceInner>, MapsResourceInner> beginUpdate(String resourceGroupName, String mapName, MapsResourceTagsUpdate properties, Context context) {
        return this.beginUpdateAsync(resourceGroupName, mapName, properties, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<MapsResourceInner> updateAsync(String resourceGroupName, String mapName, MapsResourceTagsUpdate properties) {
        return this.beginUpdateAsync(resourceGroupName, mapName, properties).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<MapsResourceInner> updateAsync(String resourceGroupName, String mapName, MapsResourceTagsUpdate properties, Context context) {
        return this.beginUpdateAsync(resourceGroupName, mapName, properties, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MapsResourceInner update(String resourceGroupName, String mapName, MapsResourceTagsUpdate properties) {
        return (MapsResourceInner)((Object)this.updateAsync(resourceGroupName, mapName, properties).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MapsResourceInner update(String resourceGroupName, String mapName, MapsResourceTagsUpdate properties, Context context) {
        return (MapsResourceInner)((Object)this.updateAsync(resourceGroupName, mapName, properties, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String mapName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (mapName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter mapName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, mapName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String mapName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (mapName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter mapName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, mapName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String mapName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, mapName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String mapName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, mapName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String mapName) {
        return this.beginDeleteAsync(resourceGroupName, mapName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String mapName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, mapName, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String mapName) {
        return this.beginDeleteAsync(resourceGroupName, mapName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String mapName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, mapName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String mapName) {
        this.deleteAsync(resourceGroupName, mapName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String mapName, Context context) {
        this.deleteAsync(resourceGroupName, mapName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MapsResourceInner>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroup(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MapsResourceListResult)res.getValue()).value(), ((MapsResourceListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MapsResourceInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroup(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MapsResourceListResult)res.getValue()).value(), ((MapsResourceListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<MapsResourceInner> listByResourceGroupAsync(String resourceGroupName) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<MapsResourceInner> listByResourceGroupAsync(String resourceGroupName, Context context) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, context), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MapsResourceInner> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MapsResourceInner> listByResourceGroup(String resourceGroupName, Context context) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MapsResourceInner>> listSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MapsResourceListResult)res.getValue()).value(), ((MapsResourceListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MapsResourceInner>> listSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MapsResourceListResult)res.getValue()).value(), ((MapsResourceListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<MapsResourceInner> listAsync() {
        return new PagedFlux(() -> this.listSinglePageAsync(), nextLink -> this.listBySubscriptionNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<MapsResourceInner> listAsync(Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(context), nextLink -> this.listBySubscriptionNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MapsResourceInner> list() {
        return new PagedIterable(this.listAsync());
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MapsResourceInner> list(Context context) {
        return new PagedIterable(this.listAsync(context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> getDependencyViewForFocusedMachineWithResponseAsync(String resourceGroupName, String mapName, GetDependencyViewForFocusedMachineRequest body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (mapName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter mapName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getDependencyViewForFocusedMachine(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, mapName, "application/json", "application/json", body, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> getDependencyViewForFocusedMachineWithResponseAsync(String resourceGroupName, String mapName, GetDependencyViewForFocusedMachineRequest body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (mapName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter mapName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String contentType = "application/json";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getDependencyViewForFocusedMachine(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, mapName, "application/json", "application/json", body, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginGetDependencyViewForFocusedMachineAsync(String resourceGroupName, String mapName, GetDependencyViewForFocusedMachineRequest body) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.getDependencyViewForFocusedMachineWithResponseAsync(resourceGroupName, mapName, body);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginGetDependencyViewForFocusedMachineAsync(String resourceGroupName, String mapName, GetDependencyViewForFocusedMachineRequest body, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.getDependencyViewForFocusedMachineWithResponseAsync(resourceGroupName, mapName, body, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginGetDependencyViewForFocusedMachine(String resourceGroupName, String mapName, GetDependencyViewForFocusedMachineRequest body) {
        return this.beginGetDependencyViewForFocusedMachineAsync(resourceGroupName, mapName, body).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginGetDependencyViewForFocusedMachine(String resourceGroupName, String mapName, GetDependencyViewForFocusedMachineRequest body, Context context) {
        return this.beginGetDependencyViewForFocusedMachineAsync(resourceGroupName, mapName, body, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> getDependencyViewForFocusedMachineAsync(String resourceGroupName, String mapName, GetDependencyViewForFocusedMachineRequest body) {
        return this.beginGetDependencyViewForFocusedMachineAsync(resourceGroupName, mapName, body).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> getDependencyViewForFocusedMachineAsync(String resourceGroupName, String mapName, GetDependencyViewForFocusedMachineRequest body, Context context) {
        return this.beginGetDependencyViewForFocusedMachineAsync(resourceGroupName, mapName, body, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void getDependencyViewForFocusedMachine(String resourceGroupName, String mapName, GetDependencyViewForFocusedMachineRequest body) {
        this.getDependencyViewForFocusedMachineAsync(resourceGroupName, mapName, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void getDependencyViewForFocusedMachine(String resourceGroupName, String mapName, GetDependencyViewForFocusedMachineRequest body, Context context) {
        this.getDependencyViewForFocusedMachineAsync(resourceGroupName, mapName, body, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> getConnectionsWithConnectedMachineForFocusedMachineWithResponseAsync(String resourceGroupName, String mapName, GetConnectionsWithConnectedMachineForFocusedMachineRequest body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (mapName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter mapName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getConnectionsWithConnectedMachineForFocusedMachine(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, mapName, "application/json", "application/json", body, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> getConnectionsWithConnectedMachineForFocusedMachineWithResponseAsync(String resourceGroupName, String mapName, GetConnectionsWithConnectedMachineForFocusedMachineRequest body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (mapName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter mapName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String contentType = "application/json";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getConnectionsWithConnectedMachineForFocusedMachine(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, mapName, "application/json", "application/json", body, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginGetConnectionsWithConnectedMachineForFocusedMachineAsync(String resourceGroupName, String mapName, GetConnectionsWithConnectedMachineForFocusedMachineRequest body) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.getConnectionsWithConnectedMachineForFocusedMachineWithResponseAsync(resourceGroupName, mapName, body);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginGetConnectionsWithConnectedMachineForFocusedMachineAsync(String resourceGroupName, String mapName, GetConnectionsWithConnectedMachineForFocusedMachineRequest body, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.getConnectionsWithConnectedMachineForFocusedMachineWithResponseAsync(resourceGroupName, mapName, body, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginGetConnectionsWithConnectedMachineForFocusedMachine(String resourceGroupName, String mapName, GetConnectionsWithConnectedMachineForFocusedMachineRequest body) {
        return this.beginGetConnectionsWithConnectedMachineForFocusedMachineAsync(resourceGroupName, mapName, body).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginGetConnectionsWithConnectedMachineForFocusedMachine(String resourceGroupName, String mapName, GetConnectionsWithConnectedMachineForFocusedMachineRequest body, Context context) {
        return this.beginGetConnectionsWithConnectedMachineForFocusedMachineAsync(resourceGroupName, mapName, body, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> getConnectionsWithConnectedMachineForFocusedMachineAsync(String resourceGroupName, String mapName, GetConnectionsWithConnectedMachineForFocusedMachineRequest body) {
        return this.beginGetConnectionsWithConnectedMachineForFocusedMachineAsync(resourceGroupName, mapName, body).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> getConnectionsWithConnectedMachineForFocusedMachineAsync(String resourceGroupName, String mapName, GetConnectionsWithConnectedMachineForFocusedMachineRequest body, Context context) {
        return this.beginGetConnectionsWithConnectedMachineForFocusedMachineAsync(resourceGroupName, mapName, body, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void getConnectionsWithConnectedMachineForFocusedMachine(String resourceGroupName, String mapName, GetConnectionsWithConnectedMachineForFocusedMachineRequest body) {
        this.getConnectionsWithConnectedMachineForFocusedMachineAsync(resourceGroupName, mapName, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void getConnectionsWithConnectedMachineForFocusedMachine(String resourceGroupName, String mapName, GetConnectionsWithConnectedMachineForFocusedMachineRequest body, Context context) {
        this.getConnectionsWithConnectedMachineForFocusedMachineAsync(resourceGroupName, mapName, body, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> getConnectionsForProcessOnFocusedMachineWithResponseAsync(String resourceGroupName, String mapName, GetConnectionsForProcessOnFocusedMachineRequest body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (mapName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter mapName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getConnectionsForProcessOnFocusedMachine(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, mapName, "application/json", "application/json", body, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> getConnectionsForProcessOnFocusedMachineWithResponseAsync(String resourceGroupName, String mapName, GetConnectionsForProcessOnFocusedMachineRequest body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (mapName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter mapName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String contentType = "application/json";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getConnectionsForProcessOnFocusedMachine(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, mapName, "application/json", "application/json", body, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginGetConnectionsForProcessOnFocusedMachineAsync(String resourceGroupName, String mapName, GetConnectionsForProcessOnFocusedMachineRequest body) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.getConnectionsForProcessOnFocusedMachineWithResponseAsync(resourceGroupName, mapName, body);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginGetConnectionsForProcessOnFocusedMachineAsync(String resourceGroupName, String mapName, GetConnectionsForProcessOnFocusedMachineRequest body, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.getConnectionsForProcessOnFocusedMachineWithResponseAsync(resourceGroupName, mapName, body, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginGetConnectionsForProcessOnFocusedMachine(String resourceGroupName, String mapName, GetConnectionsForProcessOnFocusedMachineRequest body) {
        return this.beginGetConnectionsForProcessOnFocusedMachineAsync(resourceGroupName, mapName, body).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginGetConnectionsForProcessOnFocusedMachine(String resourceGroupName, String mapName, GetConnectionsForProcessOnFocusedMachineRequest body, Context context) {
        return this.beginGetConnectionsForProcessOnFocusedMachineAsync(resourceGroupName, mapName, body, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> getConnectionsForProcessOnFocusedMachineAsync(String resourceGroupName, String mapName, GetConnectionsForProcessOnFocusedMachineRequest body) {
        return this.beginGetConnectionsForProcessOnFocusedMachineAsync(resourceGroupName, mapName, body).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> getConnectionsForProcessOnFocusedMachineAsync(String resourceGroupName, String mapName, GetConnectionsForProcessOnFocusedMachineRequest body, Context context) {
        return this.beginGetConnectionsForProcessOnFocusedMachineAsync(resourceGroupName, mapName, body, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void getConnectionsForProcessOnFocusedMachine(String resourceGroupName, String mapName, GetConnectionsForProcessOnFocusedMachineRequest body) {
        this.getConnectionsForProcessOnFocusedMachineAsync(resourceGroupName, mapName, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void getConnectionsForProcessOnFocusedMachine(String resourceGroupName, String mapName, GetConnectionsForProcessOnFocusedMachineRequest body, Context context) {
        this.getConnectionsForProcessOnFocusedMachineAsync(resourceGroupName, mapName, body, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> exportDependenciesWithResponseAsync(String resourceGroupName, String mapName, ExportDependenciesRequest body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (mapName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter mapName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.exportDependencies(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, mapName, "application/json", "application/json", body, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> exportDependenciesWithResponseAsync(String resourceGroupName, String mapName, ExportDependenciesRequest body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (mapName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter mapName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String contentType = "application/json";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.exportDependencies(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, mapName, "application/json", "application/json", body, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginExportDependenciesAsync(String resourceGroupName, String mapName, ExportDependenciesRequest body) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.exportDependenciesWithResponseAsync(resourceGroupName, mapName, body);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginExportDependenciesAsync(String resourceGroupName, String mapName, ExportDependenciesRequest body, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.exportDependenciesWithResponseAsync(resourceGroupName, mapName, body, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginExportDependencies(String resourceGroupName, String mapName, ExportDependenciesRequest body) {
        return this.beginExportDependenciesAsync(resourceGroupName, mapName, body).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginExportDependencies(String resourceGroupName, String mapName, ExportDependenciesRequest body, Context context) {
        return this.beginExportDependenciesAsync(resourceGroupName, mapName, body, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> exportDependenciesAsync(String resourceGroupName, String mapName, ExportDependenciesRequest body) {
        return this.beginExportDependenciesAsync(resourceGroupName, mapName, body).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> exportDependenciesAsync(String resourceGroupName, String mapName, ExportDependenciesRequest body, Context context) {
        return this.beginExportDependenciesAsync(resourceGroupName, mapName, body, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void exportDependencies(String resourceGroupName, String mapName, ExportDependenciesRequest body) {
        this.exportDependenciesAsync(resourceGroupName, mapName, body).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void exportDependencies(String resourceGroupName, String mapName, ExportDependenciesRequest body, Context context) {
        this.exportDependenciesAsync(resourceGroupName, mapName, body, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MapsResourceInner>> listByResourceGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MapsResourceListResult)res.getValue()).value(), ((MapsResourceListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MapsResourceInner>> listByResourceGroupNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MapsResourceListResult)res.getValue()).value(), ((MapsResourceListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MapsResourceInner>> listBySubscriptionNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBySubscriptionNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MapsResourceListResult)res.getValue()).value(), ((MapsResourceListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MapsResourceInner>> listBySubscriptionNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listBySubscriptionNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((MapsResourceListResult)res.getValue()).value(), ((MapsResourceListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="DependencyMapManagem")
    public static interface MapsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DependencyMap/maps/{mapName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<MapsResourceInner>> getByResourceGroup(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="mapName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DependencyMap/maps/{mapName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="mapName") String var5, @HeaderParam(value="Content-Type") String var6, @HeaderParam(value="Accept") String var7, @BodyParam(value="application/json") MapsResourceInner var8, Context var9);

        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DependencyMap/maps/{mapName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="mapName") String var5, @HeaderParam(value="Content-Type") String var6, @HeaderParam(value="Accept") String var7, @BodyParam(value="application/json") MapsResourceTagsUpdate var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DependencyMap/maps/{mapName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="mapName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DependencyMap/maps")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<MapsResourceListResult>> listByResourceGroup(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.DependencyMap/maps")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<MapsResourceListResult>> list(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DependencyMap/maps/{mapName}/getDependencyViewForFocusedMachine")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> getDependencyViewForFocusedMachine(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="mapName") String var5, @HeaderParam(value="Content-Type") String var6, @HeaderParam(value="Accept") String var7, @BodyParam(value="application/json") GetDependencyViewForFocusedMachineRequest var8, Context var9);

        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DependencyMap/maps/{mapName}/getConnectionsWithConnectedMachineForFocusedMachine")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> getConnectionsWithConnectedMachineForFocusedMachine(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="mapName") String var5, @HeaderParam(value="Content-Type") String var6, @HeaderParam(value="Accept") String var7, @BodyParam(value="application/json") GetConnectionsWithConnectedMachineForFocusedMachineRequest var8, Context var9);

        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DependencyMap/maps/{mapName}/getConnectionsForProcessOnFocusedMachine")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> getConnectionsForProcessOnFocusedMachine(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="mapName") String var5, @HeaderParam(value="Content-Type") String var6, @HeaderParam(value="Accept") String var7, @BodyParam(value="application/json") GetConnectionsForProcessOnFocusedMachineRequest var8, Context var9);

        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DependencyMap/maps/{mapName}/exportDependencies")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> exportDependencies(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="mapName") String var5, @HeaderParam(value="Content-Type") String var6, @HeaderParam(value="Accept") String var7, @BodyParam(value="application/json") ExportDependenciesRequest var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<MapsResourceListResult>> listByResourceGroupNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<MapsResourceListResult>> listBySubscriptionNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

