/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dependencymap.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.dependencymap.fluent.DiscoverySourcesClient;
import com.azure.resourcemanager.dependencymap.fluent.models.DiscoverySourceResourceInner;
import com.azure.resourcemanager.dependencymap.implementation.DependencyMapManagementClientImpl;
import com.azure.resourcemanager.dependencymap.implementation.models.DiscoverySourceResourceListResult;
import com.azure.resourcemanager.dependencymap.models.DiscoverySourceResourceTagsUpdate;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class DiscoverySourcesClientImpl
implements DiscoverySourcesClient {
    private final DiscoverySourcesService service;
    private final DependencyMapManagementClientImpl client;

    DiscoverySourcesClientImpl(DependencyMapManagementClientImpl client) {
        this.service = (DiscoverySourcesService)RestProxy.create(DiscoverySourcesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DiscoverySourceResourceInner>> getWithResponseAsync(String resourceGroupName, String mapName, String sourceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (mapName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter mapName is required and cannot be null."));
        }
        if (sourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sourceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, mapName, sourceName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DiscoverySourceResourceInner>> getWithResponseAsync(String resourceGroupName, String mapName, String sourceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (mapName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter mapName is required and cannot be null."));
        }
        if (sourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sourceName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, mapName, sourceName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DiscoverySourceResourceInner> getAsync(String resourceGroupName, String mapName, String sourceName) {
        return this.getWithResponseAsync(resourceGroupName, mapName, sourceName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((DiscoverySourceResourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DiscoverySourceResourceInner> getWithResponse(String resourceGroupName, String mapName, String sourceName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, mapName, sourceName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DiscoverySourceResourceInner get(String resourceGroupName, String mapName, String sourceName) {
        return (DiscoverySourceResourceInner)((Object)this.getWithResponse(resourceGroupName, mapName, sourceName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String mapName, String sourceName, DiscoverySourceResourceInner resource) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (mapName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter mapName is required and cannot be null."));
        }
        if (sourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sourceName is required and cannot be null."));
        }
        if (resource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resource is required and cannot be null."));
        }
        resource.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, mapName, sourceName, "application/json", "application/json", resource, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String mapName, String sourceName, DiscoverySourceResourceInner resource, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (mapName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter mapName is required and cannot be null."));
        }
        if (sourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sourceName is required and cannot be null."));
        }
        if (resource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resource is required and cannot be null."));
        }
        resource.validate();
        String contentType = "application/json";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, mapName, sourceName, "application/json", "application/json", resource, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DiscoverySourceResourceInner>, DiscoverySourceResourceInner> beginCreateOrUpdateAsync(String resourceGroupName, String mapName, String sourceName, DiscoverySourceResourceInner resource) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, mapName, sourceName, resource);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DiscoverySourceResourceInner.class), (Type)((Object)DiscoverySourceResourceInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DiscoverySourceResourceInner>, DiscoverySourceResourceInner> beginCreateOrUpdateAsync(String resourceGroupName, String mapName, String sourceName, DiscoverySourceResourceInner resource, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, mapName, sourceName, resource, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DiscoverySourceResourceInner.class), (Type)((Object)DiscoverySourceResourceInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DiscoverySourceResourceInner>, DiscoverySourceResourceInner> beginCreateOrUpdate(String resourceGroupName, String mapName, String sourceName, DiscoverySourceResourceInner resource) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, mapName, sourceName, resource).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DiscoverySourceResourceInner>, DiscoverySourceResourceInner> beginCreateOrUpdate(String resourceGroupName, String mapName, String sourceName, DiscoverySourceResourceInner resource, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, mapName, sourceName, resource, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DiscoverySourceResourceInner> createOrUpdateAsync(String resourceGroupName, String mapName, String sourceName, DiscoverySourceResourceInner resource) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, mapName, sourceName, resource).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DiscoverySourceResourceInner> createOrUpdateAsync(String resourceGroupName, String mapName, String sourceName, DiscoverySourceResourceInner resource, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, mapName, sourceName, resource, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DiscoverySourceResourceInner createOrUpdate(String resourceGroupName, String mapName, String sourceName, DiscoverySourceResourceInner resource) {
        return (DiscoverySourceResourceInner)((Object)this.createOrUpdateAsync(resourceGroupName, mapName, sourceName, resource).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DiscoverySourceResourceInner createOrUpdate(String resourceGroupName, String mapName, String sourceName, DiscoverySourceResourceInner resource, Context context) {
        return (DiscoverySourceResourceInner)((Object)this.createOrUpdateAsync(resourceGroupName, mapName, sourceName, resource, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String mapName, String sourceName, DiscoverySourceResourceTagsUpdate properties) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (mapName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter mapName is required and cannot be null."));
        }
        if (sourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sourceName is required and cannot be null."));
        }
        if (properties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter properties is required and cannot be null."));
        }
        properties.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, mapName, sourceName, "application/json", "application/json", properties, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String mapName, String sourceName, DiscoverySourceResourceTagsUpdate properties, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (mapName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter mapName is required and cannot be null."));
        }
        if (sourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sourceName is required and cannot be null."));
        }
        if (properties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter properties is required and cannot be null."));
        }
        properties.validate();
        String contentType = "application/json";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, mapName, sourceName, "application/json", "application/json", properties, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DiscoverySourceResourceInner>, DiscoverySourceResourceInner> beginUpdateAsync(String resourceGroupName, String mapName, String sourceName, DiscoverySourceResourceTagsUpdate properties) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, mapName, sourceName, properties);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DiscoverySourceResourceInner.class), (Type)((Object)DiscoverySourceResourceInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DiscoverySourceResourceInner>, DiscoverySourceResourceInner> beginUpdateAsync(String resourceGroupName, String mapName, String sourceName, DiscoverySourceResourceTagsUpdate properties, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, mapName, sourceName, properties, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DiscoverySourceResourceInner.class), (Type)((Object)DiscoverySourceResourceInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DiscoverySourceResourceInner>, DiscoverySourceResourceInner> beginUpdate(String resourceGroupName, String mapName, String sourceName, DiscoverySourceResourceTagsUpdate properties) {
        return this.beginUpdateAsync(resourceGroupName, mapName, sourceName, properties).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DiscoverySourceResourceInner>, DiscoverySourceResourceInner> beginUpdate(String resourceGroupName, String mapName, String sourceName, DiscoverySourceResourceTagsUpdate properties, Context context) {
        return this.beginUpdateAsync(resourceGroupName, mapName, sourceName, properties, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DiscoverySourceResourceInner> updateAsync(String resourceGroupName, String mapName, String sourceName, DiscoverySourceResourceTagsUpdate properties) {
        return this.beginUpdateAsync(resourceGroupName, mapName, sourceName, properties).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DiscoverySourceResourceInner> updateAsync(String resourceGroupName, String mapName, String sourceName, DiscoverySourceResourceTagsUpdate properties, Context context) {
        return this.beginUpdateAsync(resourceGroupName, mapName, sourceName, properties, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DiscoverySourceResourceInner update(String resourceGroupName, String mapName, String sourceName, DiscoverySourceResourceTagsUpdate properties) {
        return (DiscoverySourceResourceInner)((Object)this.updateAsync(resourceGroupName, mapName, sourceName, properties).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DiscoverySourceResourceInner update(String resourceGroupName, String mapName, String sourceName, DiscoverySourceResourceTagsUpdate properties, Context context) {
        return (DiscoverySourceResourceInner)((Object)this.updateAsync(resourceGroupName, mapName, sourceName, properties, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String mapName, String sourceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (mapName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter mapName is required and cannot be null."));
        }
        if (sourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sourceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, mapName, sourceName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String mapName, String sourceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (mapName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter mapName is required and cannot be null."));
        }
        if (sourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sourceName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, mapName, sourceName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String mapName, String sourceName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, mapName, sourceName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String mapName, String sourceName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, mapName, sourceName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String mapName, String sourceName) {
        return this.beginDeleteAsync(resourceGroupName, mapName, sourceName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String mapName, String sourceName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, mapName, sourceName, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String mapName, String sourceName) {
        return this.beginDeleteAsync(resourceGroupName, mapName, sourceName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String mapName, String sourceName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, mapName, sourceName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String mapName, String sourceName) {
        this.deleteAsync(resourceGroupName, mapName, sourceName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String mapName, String sourceName, Context context) {
        this.deleteAsync(resourceGroupName, mapName, sourceName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DiscoverySourceResourceInner>> listByMapsResourceSinglePageAsync(String resourceGroupName, String mapName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (mapName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter mapName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByMapsResource(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, mapName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DiscoverySourceResourceListResult)res.getValue()).value(), ((DiscoverySourceResourceListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DiscoverySourceResourceInner>> listByMapsResourceSinglePageAsync(String resourceGroupName, String mapName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (mapName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter mapName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByMapsResource(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, mapName, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DiscoverySourceResourceListResult)res.getValue()).value(), ((DiscoverySourceResourceListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DiscoverySourceResourceInner> listByMapsResourceAsync(String resourceGroupName, String mapName) {
        return new PagedFlux(() -> this.listByMapsResourceSinglePageAsync(resourceGroupName, mapName), nextLink -> this.listByMapsResourceNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DiscoverySourceResourceInner> listByMapsResourceAsync(String resourceGroupName, String mapName, Context context) {
        return new PagedFlux(() -> this.listByMapsResourceSinglePageAsync(resourceGroupName, mapName, context), nextLink -> this.listByMapsResourceNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DiscoverySourceResourceInner> listByMapsResource(String resourceGroupName, String mapName) {
        return new PagedIterable(this.listByMapsResourceAsync(resourceGroupName, mapName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DiscoverySourceResourceInner> listByMapsResource(String resourceGroupName, String mapName, Context context) {
        return new PagedIterable(this.listByMapsResourceAsync(resourceGroupName, mapName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DiscoverySourceResourceInner>> listByMapsResourceNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByMapsResourceNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DiscoverySourceResourceListResult)res.getValue()).value(), ((DiscoverySourceResourceListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DiscoverySourceResourceInner>> listByMapsResourceNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByMapsResourceNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DiscoverySourceResourceListResult)res.getValue()).value(), ((DiscoverySourceResourceListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="DependencyMapManagem")
    public static interface DiscoverySourcesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DependencyMap/maps/{mapName}/discoverySources/{sourceName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DiscoverySourceResourceInner>> get(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="mapName") String var5, @PathParam(value="sourceName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DependencyMap/maps/{mapName}/discoverySources/{sourceName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="mapName") String var5, @PathParam(value="sourceName") String var6, @HeaderParam(value="Content-Type") String var7, @HeaderParam(value="Accept") String var8, @BodyParam(value="application/json") DiscoverySourceResourceInner var9, Context var10);

        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DependencyMap/maps/{mapName}/discoverySources/{sourceName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="mapName") String var5, @PathParam(value="sourceName") String var6, @HeaderParam(value="Content-Type") String var7, @HeaderParam(value="Accept") String var8, @BodyParam(value="application/json") DiscoverySourceResourceTagsUpdate var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DependencyMap/maps/{mapName}/discoverySources/{sourceName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="mapName") String var5, @PathParam(value="sourceName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DependencyMap/maps/{mapName}/discoverySources")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DiscoverySourceResourceListResult>> listByMapsResource(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="mapName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DiscoverySourceResourceListResult>> listByMapsResourceNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

