/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dependencymap.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dependencymap.models.DiscoverySourceResourceProperties;
import java.io.IOException;
import java.util.Map;

public final class DiscoverySourceResourceInner
extends Resource {
    private DiscoverySourceResourceProperties properties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    public DiscoverySourceResourceProperties properties() {
        return this.properties;
    }

    public DiscoverySourceResourceInner withProperties(DiscoverySourceResourceProperties properties) {
        this.properties = properties;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public DiscoverySourceResourceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public DiscoverySourceResourceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static DiscoverySourceResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return (DiscoverySourceResourceInner)((Object)jsonReader.readObject(reader -> {
            DiscoverySourceResourceInner deserializedDiscoverySourceResourceInner = new DiscoverySourceResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDiscoverySourceResourceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDiscoverySourceResourceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDiscoverySourceResourceInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedDiscoverySourceResourceInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedDiscoverySourceResourceInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedDiscoverySourceResourceInner.properties = DiscoverySourceResourceProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedDiscoverySourceResourceInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDiscoverySourceResourceInner;
        }));
    }
}

