/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.AbsoluteMarker;
import com.azure.resourcemanager.dataprotection.models.BackupCriteria;
import com.azure.resourcemanager.dataprotection.models.Day;
import com.azure.resourcemanager.dataprotection.models.DayOfWeek;
import com.azure.resourcemanager.dataprotection.models.Month;
import com.azure.resourcemanager.dataprotection.models.WeekNumber;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.List;

public final class ScheduleBasedBackupCriteria
extends BackupCriteria {
    private String objectType = "ScheduleBasedBackupCriteria";
    private List<AbsoluteMarker> absoluteCriteria;
    private List<Day> daysOfMonth;
    private List<DayOfWeek> daysOfTheWeek;
    private List<Month> monthsOfYear;
    private List<OffsetDateTime> scheduleTimes;
    private List<WeekNumber> weeksOfTheMonth;

    @Override
    public String objectType() {
        return this.objectType;
    }

    public List<AbsoluteMarker> absoluteCriteria() {
        return this.absoluteCriteria;
    }

    public ScheduleBasedBackupCriteria withAbsoluteCriteria(List<AbsoluteMarker> absoluteCriteria) {
        this.absoluteCriteria = absoluteCriteria;
        return this;
    }

    public List<Day> daysOfMonth() {
        return this.daysOfMonth;
    }

    public ScheduleBasedBackupCriteria withDaysOfMonth(List<Day> daysOfMonth) {
        this.daysOfMonth = daysOfMonth;
        return this;
    }

    public List<DayOfWeek> daysOfTheWeek() {
        return this.daysOfTheWeek;
    }

    public ScheduleBasedBackupCriteria withDaysOfTheWeek(List<DayOfWeek> daysOfTheWeek) {
        this.daysOfTheWeek = daysOfTheWeek;
        return this;
    }

    public List<Month> monthsOfYear() {
        return this.monthsOfYear;
    }

    public ScheduleBasedBackupCriteria withMonthsOfYear(List<Month> monthsOfYear) {
        this.monthsOfYear = monthsOfYear;
        return this;
    }

    public List<OffsetDateTime> scheduleTimes() {
        return this.scheduleTimes;
    }

    public ScheduleBasedBackupCriteria withScheduleTimes(List<OffsetDateTime> scheduleTimes) {
        this.scheduleTimes = scheduleTimes;
        return this;
    }

    public List<WeekNumber> weeksOfTheMonth() {
        return this.weeksOfTheMonth;
    }

    public ScheduleBasedBackupCriteria withWeeksOfTheMonth(List<WeekNumber> weeksOfTheMonth) {
        this.weeksOfTheMonth = weeksOfTheMonth;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("objectType", this.objectType);
        jsonWriter.writeArrayField("absoluteCriteria", this.absoluteCriteria, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("daysOfMonth", this.daysOfMonth, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("daysOfTheWeek", this.daysOfTheWeek, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("monthsOfYear", this.monthsOfYear, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("scheduleTimes", this.scheduleTimes, (writer, element) -> writer.writeString(element == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format((TemporalAccessor)element)));
        jsonWriter.writeArrayField("weeksOfTheMonth", this.weeksOfTheMonth, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        return jsonWriter.writeEndObject();
    }

    public static ScheduleBasedBackupCriteria fromJson(JsonReader jsonReader) throws IOException {
        return (ScheduleBasedBackupCriteria)jsonReader.readObject(reader -> {
            ScheduleBasedBackupCriteria deserializedScheduleBasedBackupCriteria = new ScheduleBasedBackupCriteria();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("objectType".equals(fieldName)) {
                    deserializedScheduleBasedBackupCriteria.objectType = reader.getString();
                    continue;
                }
                if ("absoluteCriteria".equals(fieldName)) {
                    List absoluteCriteria;
                    deserializedScheduleBasedBackupCriteria.absoluteCriteria = absoluteCriteria = reader.readArray(reader1 -> AbsoluteMarker.fromString(reader1.getString()));
                    continue;
                }
                if ("daysOfMonth".equals(fieldName)) {
                    List daysOfMonth;
                    deserializedScheduleBasedBackupCriteria.daysOfMonth = daysOfMonth = reader.readArray(reader1 -> Day.fromJson(reader1));
                    continue;
                }
                if ("daysOfTheWeek".equals(fieldName)) {
                    List daysOfTheWeek;
                    deserializedScheduleBasedBackupCriteria.daysOfTheWeek = daysOfTheWeek = reader.readArray(reader1 -> DayOfWeek.fromString(reader1.getString()));
                    continue;
                }
                if ("monthsOfYear".equals(fieldName)) {
                    List monthsOfYear;
                    deserializedScheduleBasedBackupCriteria.monthsOfYear = monthsOfYear = reader.readArray(reader1 -> Month.fromString(reader1.getString()));
                    continue;
                }
                if ("scheduleTimes".equals(fieldName)) {
                    List scheduleTimes;
                    deserializedScheduleBasedBackupCriteria.scheduleTimes = scheduleTimes = reader.readArray(reader1 -> (OffsetDateTime)reader1.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("weeksOfTheMonth".equals(fieldName)) {
                    List weeksOfTheMonth;
                    deserializedScheduleBasedBackupCriteria.weeksOfTheMonth = weeksOfTheMonth = reader.readArray(reader1 -> WeekNumber.fromString(reader1.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedScheduleBasedBackupCriteria;
        });
    }
}

