/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.AuthCredentials;
import com.azure.resourcemanager.dataprotection.models.Datasource;
import com.azure.resourcemanager.dataprotection.models.DatasourceSet;
import com.azure.resourcemanager.dataprotection.models.RecoveryOption;
import com.azure.resourcemanager.dataprotection.models.RestoreTargetInfoBase;
import java.io.IOException;

public final class RestoreTargetInfo
extends RestoreTargetInfoBase {
    private String objectType = "RestoreTargetInfo";
    private Datasource datasourceInfo;
    private DatasourceSet datasourceSetInfo;
    private AuthCredentials datasourceAuthCredentials;

    @Override
    public String objectType() {
        return this.objectType;
    }

    public Datasource datasourceInfo() {
        return this.datasourceInfo;
    }

    public RestoreTargetInfo withDatasourceInfo(Datasource datasourceInfo) {
        this.datasourceInfo = datasourceInfo;
        return this;
    }

    public DatasourceSet datasourceSetInfo() {
        return this.datasourceSetInfo;
    }

    public RestoreTargetInfo withDatasourceSetInfo(DatasourceSet datasourceSetInfo) {
        this.datasourceSetInfo = datasourceSetInfo;
        return this;
    }

    public AuthCredentials datasourceAuthCredentials() {
        return this.datasourceAuthCredentials;
    }

    public RestoreTargetInfo withDatasourceAuthCredentials(AuthCredentials datasourceAuthCredentials) {
        this.datasourceAuthCredentials = datasourceAuthCredentials;
        return this;
    }

    @Override
    public RestoreTargetInfo withRecoveryOption(RecoveryOption recoveryOption) {
        super.withRecoveryOption(recoveryOption);
        return this;
    }

    @Override
    public RestoreTargetInfo withRestoreLocation(String restoreLocation) {
        super.withRestoreLocation(restoreLocation);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("recoveryOption", this.recoveryOption() == null ? null : this.recoveryOption().toString());
        jsonWriter.writeStringField("restoreLocation", this.restoreLocation());
        jsonWriter.writeJsonField("datasourceInfo", (JsonSerializable)this.datasourceInfo);
        jsonWriter.writeStringField("objectType", this.objectType);
        jsonWriter.writeJsonField("datasourceSetInfo", (JsonSerializable)this.datasourceSetInfo);
        jsonWriter.writeJsonField("datasourceAuthCredentials", (JsonSerializable)this.datasourceAuthCredentials);
        return jsonWriter.writeEndObject();
    }

    public static RestoreTargetInfo fromJson(JsonReader jsonReader) throws IOException {
        return (RestoreTargetInfo)jsonReader.readObject(reader -> {
            RestoreTargetInfo deserializedRestoreTargetInfo = new RestoreTargetInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("recoveryOption".equals(fieldName)) {
                    deserializedRestoreTargetInfo.withRecoveryOption(RecoveryOption.fromString(reader.getString()));
                    continue;
                }
                if ("restoreLocation".equals(fieldName)) {
                    deserializedRestoreTargetInfo.withRestoreLocation(reader.getString());
                    continue;
                }
                if ("datasourceInfo".equals(fieldName)) {
                    deserializedRestoreTargetInfo.datasourceInfo = Datasource.fromJson(reader);
                    continue;
                }
                if ("objectType".equals(fieldName)) {
                    deserializedRestoreTargetInfo.objectType = reader.getString();
                    continue;
                }
                if ("datasourceSetInfo".equals(fieldName)) {
                    deserializedRestoreTargetInfo.datasourceSetInfo = DatasourceSet.fromJson(reader);
                    continue;
                }
                if ("datasourceAuthCredentials".equals(fieldName)) {
                    deserializedRestoreTargetInfo.datasourceAuthCredentials = AuthCredentials.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRestoreTargetInfo;
        });
    }
}

