/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.FeatureSettings;
import com.azure.resourcemanager.dataprotection.models.MonitoringSettings;
import com.azure.resourcemanager.dataprotection.models.SecuritySettings;
import java.io.IOException;
import java.util.List;

public final class PatchBackupVaultInput
implements JsonSerializable<PatchBackupVaultInput> {
    private MonitoringSettings monitoringSettings;
    private SecuritySettings securitySettings;
    private FeatureSettings featureSettings;
    private List<String> resourceGuardOperationRequests;

    public MonitoringSettings monitoringSettings() {
        return this.monitoringSettings;
    }

    public PatchBackupVaultInput withMonitoringSettings(MonitoringSettings monitoringSettings) {
        this.monitoringSettings = monitoringSettings;
        return this;
    }

    public SecuritySettings securitySettings() {
        return this.securitySettings;
    }

    public PatchBackupVaultInput withSecuritySettings(SecuritySettings securitySettings) {
        this.securitySettings = securitySettings;
        return this;
    }

    public FeatureSettings featureSettings() {
        return this.featureSettings;
    }

    public PatchBackupVaultInput withFeatureSettings(FeatureSettings featureSettings) {
        this.featureSettings = featureSettings;
        return this;
    }

    public List<String> resourceGuardOperationRequests() {
        return this.resourceGuardOperationRequests;
    }

    public PatchBackupVaultInput withResourceGuardOperationRequests(List<String> resourceGuardOperationRequests) {
        this.resourceGuardOperationRequests = resourceGuardOperationRequests;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("monitoringSettings", (JsonSerializable)this.monitoringSettings);
        jsonWriter.writeJsonField("securitySettings", (JsonSerializable)this.securitySettings);
        jsonWriter.writeJsonField("featureSettings", (JsonSerializable)this.featureSettings);
        jsonWriter.writeArrayField("resourceGuardOperationRequests", this.resourceGuardOperationRequests, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static PatchBackupVaultInput fromJson(JsonReader jsonReader) throws IOException {
        return (PatchBackupVaultInput)jsonReader.readObject(reader -> {
            PatchBackupVaultInput deserializedPatchBackupVaultInput = new PatchBackupVaultInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("monitoringSettings".equals(fieldName)) {
                    deserializedPatchBackupVaultInput.monitoringSettings = MonitoringSettings.fromJson(reader);
                    continue;
                }
                if ("securitySettings".equals(fieldName)) {
                    deserializedPatchBackupVaultInput.securitySettings = SecuritySettings.fromJson(reader);
                    continue;
                }
                if ("featureSettings".equals(fieldName)) {
                    deserializedPatchBackupVaultInput.featureSettings = FeatureSettings.fromJson(reader);
                    continue;
                }
                if ("resourceGuardOperationRequests".equals(fieldName)) {
                    List resourceGuardOperationRequests;
                    deserializedPatchBackupVaultInput.resourceGuardOperationRequests = resourceGuardOperationRequests = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPatchBackupVaultInput;
        });
    }
}

