/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.AzureOperationalStoreParameters;
import com.azure.resourcemanager.dataprotection.models.DataStoreTypes;
import java.io.IOException;

public class DataStoreParameters
implements JsonSerializable<DataStoreParameters> {
    private String objectType = "DataStoreParameters";
    private DataStoreTypes dataStoreType;

    public String objectType() {
        return this.objectType;
    }

    public DataStoreTypes dataStoreType() {
        return this.dataStoreType;
    }

    public DataStoreParameters withDataStoreType(DataStoreTypes dataStoreType) {
        this.dataStoreType = dataStoreType;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("dataStoreType", this.dataStoreType == null ? null : this.dataStoreType.toString());
        jsonWriter.writeStringField("objectType", this.objectType);
        return jsonWriter.writeEndObject();
    }

    public static DataStoreParameters fromJson(JsonReader jsonReader) throws IOException {
        return (DataStoreParameters)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                DataStoreParameters dataStoreParameters;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("objectType".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("AzureOperationalStoreParameters".equals(discriminatorValue)) {
                    dataStoreParameters = AzureOperationalStoreParameters.fromJson(readerToUse.reset());
                    return dataStoreParameters;
                }
                dataStoreParameters = DataStoreParameters.fromJsonKnownDiscriminator(readerToUse.reset());
                return dataStoreParameters;
            }
        });
    }

    static DataStoreParameters fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (DataStoreParameters)jsonReader.readObject(reader -> {
            DataStoreParameters deserializedDataStoreParameters = new DataStoreParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("dataStoreType".equals(fieldName)) {
                    deserializedDataStoreParameters.dataStoreType = DataStoreTypes.fromString(reader.getString());
                    continue;
                }
                if ("objectType".equals(fieldName)) {
                    deserializedDataStoreParameters.objectType = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataStoreParameters;
        });
    }
}

