/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.AzureBackupParams;
import java.io.IOException;

public class BackupParameters
implements JsonSerializable<BackupParameters> {
    private String objectType = "BackupParameters";

    public String objectType() {
        return this.objectType;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("objectType", this.objectType);
        return jsonWriter.writeEndObject();
    }

    public static BackupParameters fromJson(JsonReader jsonReader) throws IOException {
        return (BackupParameters)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                BackupParameters backupParameters;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("objectType".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("AzureBackupParams".equals(discriminatorValue)) {
                    backupParameters = AzureBackupParams.fromJson(readerToUse.reset());
                    return backupParameters;
                }
                backupParameters = BackupParameters.fromJsonKnownDiscriminator(readerToUse.reset());
                return backupParameters;
            }
        });
    }

    static BackupParameters fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (BackupParameters)jsonReader.readObject(reader -> {
            BackupParameters deserializedBackupParameters = new BackupParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("objectType".equals(fieldName)) {
                    deserializedBackupParameters.objectType = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBackupParameters;
        });
    }
}

