/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.dataprotection.fluent.models.BackupInstanceResourceInner;
import com.azure.resourcemanager.dataprotection.models.AzureBackupRehydrationRequest;
import com.azure.resourcemanager.dataprotection.models.AzureBackupRestoreRequest;
import com.azure.resourcemanager.dataprotection.models.BackupInstance;
import com.azure.resourcemanager.dataprotection.models.OperationJobExtendedInfo;
import com.azure.resourcemanager.dataprotection.models.StopProtectionRequest;
import com.azure.resourcemanager.dataprotection.models.SuspendBackupRequest;
import com.azure.resourcemanager.dataprotection.models.SyncBackupInstanceRequest;
import com.azure.resourcemanager.dataprotection.models.TriggerBackupRequest;
import com.azure.resourcemanager.dataprotection.models.ValidateForModifyBackupRequest;
import com.azure.resourcemanager.dataprotection.models.ValidateRestoreRequestObject;
import java.util.Map;

public interface BackupInstanceResource {
    public String id();

    public String name();

    public String type();

    public BackupInstance properties();

    public Map<String, String> tags();

    public SystemData systemData();

    public String resourceGroupName();

    public BackupInstanceResourceInner innerModel();

    public Update update();

    public BackupInstanceResource refresh();

    public BackupInstanceResource refresh(Context var1);

    public OperationJobExtendedInfo adhocBackup(TriggerBackupRequest var1);

    public OperationJobExtendedInfo adhocBackup(TriggerBackupRequest var1, Context var2);

    public void validateForModifyBackup(ValidateForModifyBackupRequest var1);

    public void validateForModifyBackup(ValidateForModifyBackupRequest var1, Context var2);

    public void triggerRehydrate(AzureBackupRehydrationRequest var1);

    public void triggerRehydrate(AzureBackupRehydrationRequest var1, Context var2);

    public OperationJobExtendedInfo triggerRestore(AzureBackupRestoreRequest var1);

    public OperationJobExtendedInfo triggerRestore(AzureBackupRestoreRequest var1, Context var2);

    public void resumeBackups();

    public void resumeBackups(Context var1);

    public void resumeProtection();

    public void resumeProtection(Context var1);

    public void stopProtection();

    public void stopProtection(StopProtectionRequest var1, Context var2);

    public void suspendBackups();

    public void suspendBackups(SuspendBackupRequest var1, Context var2);

    public void syncBackupInstance(SyncBackupInstanceRequest var1);

    public void syncBackupInstance(SyncBackupInstanceRequest var1, Context var2);

    public OperationJobExtendedInfo validateForRestore(ValidateRestoreRequestObject var1);

    public OperationJobExtendedInfo validateForRestore(ValidateRestoreRequestObject var1, Context var2);

    public static interface UpdateStages {

        public static interface WithProperties {
            public Update withProperties(BackupInstance var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithProperties {
        public BackupInstanceResource apply();

        public BackupInstanceResource apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithProperties {
            public WithCreate withProperties(BackupInstance var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithProperties {
            public BackupInstanceResource create();

            public BackupInstanceResource create(Context var1);
        }

        public static interface WithParentResource {
            public WithCreate withExistingBackupVault(String var1, String var2);
        }

        public static interface Blank
        extends WithParentResource {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithCreate {
    }
}

