/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.AdlsBlobBackupDatasourceParameters;
import com.azure.resourcemanager.dataprotection.models.BlobBackupDatasourceParameters;
import com.azure.resourcemanager.dataprotection.models.KubernetesClusterBackupDatasourceParameters;
import java.io.IOException;

public class BackupDatasourceParameters
implements JsonSerializable<BackupDatasourceParameters> {
    private String objectType = "BackupDatasourceParameters";

    public String objectType() {
        return this.objectType;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("objectType", this.objectType);
        return jsonWriter.writeEndObject();
    }

    public static BackupDatasourceParameters fromJson(JsonReader jsonReader) throws IOException {
        return (BackupDatasourceParameters)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                BackupDatasourceParameters backupDatasourceParameters;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("objectType".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("KubernetesClusterBackupDatasourceParameters".equals(discriminatorValue)) {
                    backupDatasourceParameters = KubernetesClusterBackupDatasourceParameters.fromJson(readerToUse.reset());
                    return backupDatasourceParameters;
                }
                if ("BlobBackupDatasourceParameters".equals(discriminatorValue)) {
                    backupDatasourceParameters = BlobBackupDatasourceParameters.fromJsonKnownDiscriminator(readerToUse.reset());
                    return backupDatasourceParameters;
                }
                if ("AdlsBlobBackupDatasourceParameters".equals(discriminatorValue)) {
                    backupDatasourceParameters = AdlsBlobBackupDatasourceParameters.fromJson(readerToUse.reset());
                    return backupDatasourceParameters;
                }
                backupDatasourceParameters = BackupDatasourceParameters.fromJsonKnownDiscriminator(readerToUse.reset());
                return backupDatasourceParameters;
            }
        });
    }

    static BackupDatasourceParameters fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (BackupDatasourceParameters)jsonReader.readObject(reader -> {
            BackupDatasourceParameters deserializedBackupDatasourceParameters = new BackupDatasourceParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("objectType".equals(fieldName)) {
                    deserializedBackupDatasourceParameters.objectType = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBackupDatasourceParameters;
        });
    }
}

