/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.DataStoreParameters;
import com.azure.resourcemanager.dataprotection.models.DataStoreTypes;
import java.io.IOException;

public final class AzureOperationalStoreParameters
extends DataStoreParameters {
    private String objectType = "AzureOperationalStoreParameters";
    private String resourceGroupId;

    @Override
    public String objectType() {
        return this.objectType;
    }

    public String resourceGroupId() {
        return this.resourceGroupId;
    }

    public AzureOperationalStoreParameters withResourceGroupId(String resourceGroupId) {
        this.resourceGroupId = resourceGroupId;
        return this;
    }

    @Override
    public AzureOperationalStoreParameters withDataStoreType(DataStoreTypes dataStoreType) {
        super.withDataStoreType(dataStoreType);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("dataStoreType", this.dataStoreType() == null ? null : this.dataStoreType().toString());
        jsonWriter.writeStringField("objectType", this.objectType);
        jsonWriter.writeStringField("resourceGroupId", this.resourceGroupId);
        return jsonWriter.writeEndObject();
    }

    public static AzureOperationalStoreParameters fromJson(JsonReader jsonReader) throws IOException {
        return (AzureOperationalStoreParameters)jsonReader.readObject(reader -> {
            AzureOperationalStoreParameters deserializedAzureOperationalStoreParameters = new AzureOperationalStoreParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("dataStoreType".equals(fieldName)) {
                    deserializedAzureOperationalStoreParameters.withDataStoreType(DataStoreTypes.fromString(reader.getString()));
                    continue;
                }
                if ("objectType".equals(fieldName)) {
                    deserializedAzureOperationalStoreParameters.objectType = reader.getString();
                    continue;
                }
                if ("resourceGroupId".equals(fieldName)) {
                    deserializedAzureOperationalStoreParameters.resourceGroupId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureOperationalStoreParameters;
        });
    }
}

