/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.BackupParameters;
import com.azure.resourcemanager.dataprotection.models.BasePolicyRule;
import com.azure.resourcemanager.dataprotection.models.DataStoreInfoBase;
import com.azure.resourcemanager.dataprotection.models.TriggerContext;
import java.io.IOException;

public final class AzureBackupRule
extends BasePolicyRule {
    private String objectType = "AzureBackupRule";
    private BackupParameters backupParameters;
    private DataStoreInfoBase dataStore;
    private TriggerContext trigger;

    @Override
    public String objectType() {
        return this.objectType;
    }

    public BackupParameters backupParameters() {
        return this.backupParameters;
    }

    public AzureBackupRule withBackupParameters(BackupParameters backupParameters) {
        this.backupParameters = backupParameters;
        return this;
    }

    public DataStoreInfoBase dataStore() {
        return this.dataStore;
    }

    public AzureBackupRule withDataStore(DataStoreInfoBase dataStore) {
        this.dataStore = dataStore;
        return this;
    }

    public TriggerContext trigger() {
        return this.trigger;
    }

    public AzureBackupRule withTrigger(TriggerContext trigger) {
        this.trigger = trigger;
        return this;
    }

    @Override
    public AzureBackupRule withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeJsonField("dataStore", (JsonSerializable)this.dataStore);
        jsonWriter.writeJsonField("trigger", (JsonSerializable)this.trigger);
        jsonWriter.writeStringField("objectType", this.objectType);
        jsonWriter.writeJsonField("backupParameters", (JsonSerializable)this.backupParameters);
        return jsonWriter.writeEndObject();
    }

    public static AzureBackupRule fromJson(JsonReader jsonReader) throws IOException {
        return (AzureBackupRule)jsonReader.readObject(reader -> {
            AzureBackupRule deserializedAzureBackupRule = new AzureBackupRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedAzureBackupRule.withName(reader.getString());
                    continue;
                }
                if ("dataStore".equals(fieldName)) {
                    deserializedAzureBackupRule.dataStore = DataStoreInfoBase.fromJson(reader);
                    continue;
                }
                if ("trigger".equals(fieldName)) {
                    deserializedAzureBackupRule.trigger = TriggerContext.fromJson(reader);
                    continue;
                }
                if ("objectType".equals(fieldName)) {
                    deserializedAzureBackupRule.objectType = reader.getString();
                    continue;
                }
                if ("backupParameters".equals(fieldName)) {
                    deserializedAzureBackupRule.backupParameters = BackupParameters.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureBackupRule;
        });
    }
}

