/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.dataprotection.DataProtectionManager;
import com.azure.resourcemanager.dataprotection.fluent.OperationStatusBackupVaultContextsClient;
import com.azure.resourcemanager.dataprotection.fluent.models.OperationResourceInner;
import com.azure.resourcemanager.dataprotection.implementation.OperationResourceImpl;
import com.azure.resourcemanager.dataprotection.models.OperationResource;
import com.azure.resourcemanager.dataprotection.models.OperationStatusBackupVaultContexts;

public final class OperationStatusBackupVaultContextsImpl
implements OperationStatusBackupVaultContexts {
    private static final ClientLogger LOGGER = new ClientLogger(OperationStatusBackupVaultContextsImpl.class);
    private final OperationStatusBackupVaultContextsClient innerClient;
    private final DataProtectionManager serviceManager;

    public OperationStatusBackupVaultContextsImpl(OperationStatusBackupVaultContextsClient innerClient, DataProtectionManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<OperationResource> getWithResponse(String resourceGroupName, String vaultName, String operationId, Context context) {
        Response<OperationResourceInner> inner = this.serviceClient().getWithResponse(resourceGroupName, vaultName, operationId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new OperationResourceImpl((OperationResourceInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public OperationResource get(String resourceGroupName, String vaultName, String operationId) {
        OperationResourceInner inner = this.serviceClient().get(resourceGroupName, vaultName, operationId);
        if (inner != null) {
            return new OperationResourceImpl(inner, this.manager());
        }
        return null;
    }

    private OperationStatusBackupVaultContextsClient serviceClient() {
        return this.innerClient;
    }

    private DataProtectionManager manager() {
        return this.serviceManager;
    }
}

