/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.dataprotection.fluent.OperationStatusBackupVaultContextsClient;
import com.azure.resourcemanager.dataprotection.fluent.models.OperationResourceInner;
import com.azure.resourcemanager.dataprotection.implementation.DataProtectionManagementClientImpl;
import reactor.core.publisher.Mono;

public final class OperationStatusBackupVaultContextsClientImpl
implements OperationStatusBackupVaultContextsClient {
    private final OperationStatusBackupVaultContextsService service;
    private final DataProtectionManagementClientImpl client;

    OperationStatusBackupVaultContextsClientImpl(DataProtectionManagementClientImpl client) {
        this.service = (OperationStatusBackupVaultContextsService)RestProxy.create(OperationStatusBackupVaultContextsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<OperationResourceInner>> getWithResponseAsync(String resourceGroupName, String vaultName, String operationId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, vaultName, operationId, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationResourceInner> getAsync(String resourceGroupName, String vaultName, String operationId) {
        return this.getWithResponseAsync(resourceGroupName, vaultName, operationId).flatMap(res -> Mono.justOrEmpty((Object)((OperationResourceInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<OperationResourceInner> getWithResponse(String resourceGroupName, String vaultName, String operationId, Context context) {
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, vaultName, operationId, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationResourceInner get(String resourceGroupName, String vaultName, String operationId) {
        return (OperationResourceInner)this.getWithResponse(resourceGroupName, vaultName, operationId, Context.NONE).getValue();
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="DataProtectionManagementClientOperationStatusBackupVaultContexts")
    public static interface OperationStatusBackupVaultContextsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/backupVaults/{vaultName}/operationStatus/{operationId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<OperationResourceInner>> get(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="vaultName") String var5, @PathParam(value="operationId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/backupVaults/{vaultName}/operationStatus/{operationId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<OperationResourceInner> getSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="vaultName") String var5, @PathParam(value="operationId") String var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

