/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.dataprotection.fluent.FetchCrossRegionRestoreJobsClient;
import com.azure.resourcemanager.dataprotection.fluent.models.AzureBackupJobResourceInner;
import com.azure.resourcemanager.dataprotection.implementation.DataProtectionManagementClientImpl;
import com.azure.resourcemanager.dataprotection.models.CrossRegionRestoreJobRequest;
import reactor.core.publisher.Mono;

public final class FetchCrossRegionRestoreJobsClientImpl
implements FetchCrossRegionRestoreJobsClient {
    private final FetchCrossRegionRestoreJobsService service;
    private final DataProtectionManagementClientImpl client;

    FetchCrossRegionRestoreJobsClientImpl(DataProtectionManagementClientImpl client) {
        this.service = (FetchCrossRegionRestoreJobsService)RestProxy.create(FetchCrossRegionRestoreJobsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AzureBackupJobResourceInner>> getWithResponseAsync(String resourceGroupName, String location, CrossRegionRestoreJobRequest parameters) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), resourceGroupName, this.client.getSubscriptionId(), location, "application/json", "application/json", parameters, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AzureBackupJobResourceInner> getAsync(String resourceGroupName, String location, CrossRegionRestoreJobRequest parameters) {
        return this.getWithResponseAsync(resourceGroupName, location, parameters).flatMap(res -> Mono.justOrEmpty((Object)((Object)((AzureBackupJobResourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AzureBackupJobResourceInner> getWithResponse(String resourceGroupName, String location, CrossRegionRestoreJobRequest parameters, Context context) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), this.client.getApiVersion(), resourceGroupName, this.client.getSubscriptionId(), location, "application/json", "application/json", parameters, context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AzureBackupJobResourceInner get(String resourceGroupName, String location, CrossRegionRestoreJobRequest parameters) {
        return (AzureBackupJobResourceInner)((Object)this.getWithResponse(resourceGroupName, location, parameters, Context.NONE).getValue());
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="DataProtectionManagementClientFetchCrossRegionRestoreJobs")
    public static interface FetchCrossRegionRestoreJobsService {
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/locations/{location}/fetchCrossRegionRestoreJob")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AzureBackupJobResourceInner>> get(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="location") String var5, @HeaderParam(value="Content-Type") String var6, @HeaderParam(value="Accept") String var7, @BodyParam(value="application/json") CrossRegionRestoreJobRequest var8, Context var9);

        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/locations/{location}/fetchCrossRegionRestoreJob")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<AzureBackupJobResourceInner> getSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="location") String var5, @HeaderParam(value="Content-Type") String var6, @HeaderParam(value="Accept") String var7, @BodyParam(value="application/json") CrossRegionRestoreJobRequest var8, Context var9);
    }
}

