/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.dataprotection.fluent.BackupVaultOperationResultsClient;
import com.azure.resourcemanager.dataprotection.fluent.models.BackupVaultResourceInner;
import com.azure.resourcemanager.dataprotection.implementation.DataProtectionManagementClientImpl;
import com.azure.resourcemanager.dataprotection.models.BackupVaultOperationResultsGetResponse;
import reactor.core.publisher.Mono;

public final class BackupVaultOperationResultsClientImpl
implements BackupVaultOperationResultsClient {
    private final BackupVaultOperationResultsService service;
    private final DataProtectionManagementClientImpl client;

    BackupVaultOperationResultsClientImpl(DataProtectionManagementClientImpl client) {
        this.service = (BackupVaultOperationResultsService)RestProxy.create(BackupVaultOperationResultsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<BackupVaultOperationResultsGetResponse> getWithResponseAsync(String resourceGroupName, String vaultName, String operationId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, vaultName, operationId, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<BackupVaultResourceInner> getAsync(String resourceGroupName, String vaultName, String operationId) {
        return this.getWithResponseAsync(resourceGroupName, vaultName, operationId).flatMap(res -> Mono.justOrEmpty((Object)((Object)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BackupVaultOperationResultsGetResponse getWithResponse(String resourceGroupName, String vaultName, String operationId, Context context) {
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, vaultName, operationId, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BackupVaultResourceInner get(String resourceGroupName, String vaultName, String operationId) {
        return this.getWithResponse(resourceGroupName, vaultName, operationId, Context.NONE).getValue();
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="DataProtectionManagementClientBackupVaultOperationResults")
    public static interface BackupVaultOperationResultsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/backupVaults/{vaultName}/operationResults/{operationId}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<BackupVaultOperationResultsGetResponse> get(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="vaultName") String var5, @PathParam(value="operationId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/backupVaults/{vaultName}/operationResults/{operationId}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public BackupVaultOperationResultsGetResponse getSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="vaultName") String var5, @PathParam(value="operationId") String var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

