/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.dataprotection.DataProtectionManager;
import com.azure.resourcemanager.dataprotection.fluent.BackupInstancesClient;
import com.azure.resourcemanager.dataprotection.fluent.models.BackupInstanceResourceInner;
import com.azure.resourcemanager.dataprotection.fluent.models.OperationJobExtendedInfoInner;
import com.azure.resourcemanager.dataprotection.implementation.BackupInstanceResourceImpl;
import com.azure.resourcemanager.dataprotection.implementation.OperationJobExtendedInfoImpl;
import com.azure.resourcemanager.dataprotection.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.dataprotection.models.AzureBackupRehydrationRequest;
import com.azure.resourcemanager.dataprotection.models.AzureBackupRestoreRequest;
import com.azure.resourcemanager.dataprotection.models.BackupInstanceResource;
import com.azure.resourcemanager.dataprotection.models.BackupInstances;
import com.azure.resourcemanager.dataprotection.models.CrossRegionRestoreRequestObject;
import com.azure.resourcemanager.dataprotection.models.OperationJobExtendedInfo;
import com.azure.resourcemanager.dataprotection.models.StopProtectionRequest;
import com.azure.resourcemanager.dataprotection.models.SuspendBackupRequest;
import com.azure.resourcemanager.dataprotection.models.SyncBackupInstanceRequest;
import com.azure.resourcemanager.dataprotection.models.TriggerBackupRequest;
import com.azure.resourcemanager.dataprotection.models.ValidateCrossRegionRestoreRequestObject;
import com.azure.resourcemanager.dataprotection.models.ValidateForBackupRequest;
import com.azure.resourcemanager.dataprotection.models.ValidateForModifyBackupRequest;
import com.azure.resourcemanager.dataprotection.models.ValidateRestoreRequestObject;

public final class BackupInstancesImpl
implements BackupInstances {
    private static final ClientLogger LOGGER = new ClientLogger(BackupInstancesImpl.class);
    private final BackupInstancesClient innerClient;
    private final DataProtectionManager serviceManager;

    public BackupInstancesImpl(BackupInstancesClient innerClient, DataProtectionManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<BackupInstanceResource> getBackupInstanceOperationResultWithResponse(String resourceGroupName, String vaultName, String backupInstanceName, String operationId, Context context) {
        Response<BackupInstanceResourceInner> inner = this.serviceClient().getBackupInstanceOperationResultWithResponse(resourceGroupName, vaultName, backupInstanceName, operationId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new BackupInstanceResourceImpl((BackupInstanceResourceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public BackupInstanceResource getBackupInstanceOperationResult(String resourceGroupName, String vaultName, String backupInstanceName, String operationId) {
        BackupInstanceResourceInner inner = this.serviceClient().getBackupInstanceOperationResult(resourceGroupName, vaultName, backupInstanceName, operationId);
        if (inner != null) {
            return new BackupInstanceResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<BackupInstanceResource> list(String resourceGroupName, String vaultName) {
        PagedIterable<BackupInstanceResourceInner> inner = this.serviceClient().list(resourceGroupName, vaultName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new BackupInstanceResourceImpl((BackupInstanceResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<BackupInstanceResource> list(String resourceGroupName, String vaultName, Context context) {
        PagedIterable<BackupInstanceResourceInner> inner = this.serviceClient().list(resourceGroupName, vaultName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new BackupInstanceResourceImpl((BackupInstanceResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public OperationJobExtendedInfo validateForBackup(String resourceGroupName, String vaultName, ValidateForBackupRequest parameters) {
        OperationJobExtendedInfoInner inner = this.serviceClient().validateForBackup(resourceGroupName, vaultName, parameters);
        if (inner != null) {
            return new OperationJobExtendedInfoImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationJobExtendedInfo validateForBackup(String resourceGroupName, String vaultName, ValidateForBackupRequest parameters, Context context) {
        OperationJobExtendedInfoInner inner = this.serviceClient().validateForBackup(resourceGroupName, vaultName, parameters, context);
        if (inner != null) {
            return new OperationJobExtendedInfoImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<BackupInstanceResource> getWithResponse(String resourceGroupName, String vaultName, String backupInstanceName, Context context) {
        Response<BackupInstanceResourceInner> inner = this.serviceClient().getWithResponse(resourceGroupName, vaultName, backupInstanceName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new BackupInstanceResourceImpl((BackupInstanceResourceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public BackupInstanceResource get(String resourceGroupName, String vaultName, String backupInstanceName) {
        BackupInstanceResourceInner inner = this.serviceClient().get(resourceGroupName, vaultName, backupInstanceName);
        if (inner != null) {
            return new BackupInstanceResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String vaultName, String backupInstanceName) {
        this.serviceClient().delete(resourceGroupName, vaultName, backupInstanceName);
    }

    @Override
    public void delete(String resourceGroupName, String vaultName, String backupInstanceName, Context context) {
        this.serviceClient().delete(resourceGroupName, vaultName, backupInstanceName, context);
    }

    @Override
    public OperationJobExtendedInfo adhocBackup(String resourceGroupName, String vaultName, String backupInstanceName, TriggerBackupRequest parameters) {
        OperationJobExtendedInfoInner inner = this.serviceClient().adhocBackup(resourceGroupName, vaultName, backupInstanceName, parameters);
        if (inner != null) {
            return new OperationJobExtendedInfoImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationJobExtendedInfo adhocBackup(String resourceGroupName, String vaultName, String backupInstanceName, TriggerBackupRequest parameters, Context context) {
        OperationJobExtendedInfoInner inner = this.serviceClient().adhocBackup(resourceGroupName, vaultName, backupInstanceName, parameters, context);
        if (inner != null) {
            return new OperationJobExtendedInfoImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void validateForModifyBackup(String resourceGroupName, String vaultName, String backupInstanceName, ValidateForModifyBackupRequest parameters) {
        this.serviceClient().validateForModifyBackup(resourceGroupName, vaultName, backupInstanceName, parameters);
    }

    @Override
    public void validateForModifyBackup(String resourceGroupName, String vaultName, String backupInstanceName, ValidateForModifyBackupRequest parameters, Context context) {
        this.serviceClient().validateForModifyBackup(resourceGroupName, vaultName, backupInstanceName, parameters, context);
    }

    @Override
    public void triggerRehydrate(String resourceGroupName, String vaultName, String backupInstanceName, AzureBackupRehydrationRequest parameters) {
        this.serviceClient().triggerRehydrate(resourceGroupName, vaultName, backupInstanceName, parameters);
    }

    @Override
    public void triggerRehydrate(String resourceGroupName, String vaultName, String backupInstanceName, AzureBackupRehydrationRequest parameters, Context context) {
        this.serviceClient().triggerRehydrate(resourceGroupName, vaultName, backupInstanceName, parameters, context);
    }

    @Override
    public OperationJobExtendedInfo triggerRestore(String resourceGroupName, String vaultName, String backupInstanceName, AzureBackupRestoreRequest parameters) {
        OperationJobExtendedInfoInner inner = this.serviceClient().triggerRestore(resourceGroupName, vaultName, backupInstanceName, parameters);
        if (inner != null) {
            return new OperationJobExtendedInfoImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationJobExtendedInfo triggerRestore(String resourceGroupName, String vaultName, String backupInstanceName, AzureBackupRestoreRequest parameters, Context context) {
        OperationJobExtendedInfoInner inner = this.serviceClient().triggerRestore(resourceGroupName, vaultName, backupInstanceName, parameters, context);
        if (inner != null) {
            return new OperationJobExtendedInfoImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void resumeBackups(String resourceGroupName, String vaultName, String backupInstanceName) {
        this.serviceClient().resumeBackups(resourceGroupName, vaultName, backupInstanceName);
    }

    @Override
    public void resumeBackups(String resourceGroupName, String vaultName, String backupInstanceName, Context context) {
        this.serviceClient().resumeBackups(resourceGroupName, vaultName, backupInstanceName, context);
    }

    @Override
    public void resumeProtection(String resourceGroupName, String vaultName, String backupInstanceName) {
        this.serviceClient().resumeProtection(resourceGroupName, vaultName, backupInstanceName);
    }

    @Override
    public void resumeProtection(String resourceGroupName, String vaultName, String backupInstanceName, Context context) {
        this.serviceClient().resumeProtection(resourceGroupName, vaultName, backupInstanceName, context);
    }

    @Override
    public void stopProtection(String resourceGroupName, String vaultName, String backupInstanceName) {
        this.serviceClient().stopProtection(resourceGroupName, vaultName, backupInstanceName);
    }

    @Override
    public void stopProtection(String resourceGroupName, String vaultName, String backupInstanceName, StopProtectionRequest parameters, Context context) {
        this.serviceClient().stopProtection(resourceGroupName, vaultName, backupInstanceName, parameters, context);
    }

    @Override
    public void suspendBackups(String resourceGroupName, String vaultName, String backupInstanceName) {
        this.serviceClient().suspendBackups(resourceGroupName, vaultName, backupInstanceName);
    }

    @Override
    public void suspendBackups(String resourceGroupName, String vaultName, String backupInstanceName, SuspendBackupRequest parameters, Context context) {
        this.serviceClient().suspendBackups(resourceGroupName, vaultName, backupInstanceName, parameters, context);
    }

    @Override
    public void syncBackupInstance(String resourceGroupName, String vaultName, String backupInstanceName, SyncBackupInstanceRequest parameters) {
        this.serviceClient().syncBackupInstance(resourceGroupName, vaultName, backupInstanceName, parameters);
    }

    @Override
    public void syncBackupInstance(String resourceGroupName, String vaultName, String backupInstanceName, SyncBackupInstanceRequest parameters, Context context) {
        this.serviceClient().syncBackupInstance(resourceGroupName, vaultName, backupInstanceName, parameters, context);
    }

    @Override
    public OperationJobExtendedInfo validateForRestore(String resourceGroupName, String vaultName, String backupInstanceName, ValidateRestoreRequestObject parameters) {
        OperationJobExtendedInfoInner inner = this.serviceClient().validateForRestore(resourceGroupName, vaultName, backupInstanceName, parameters);
        if (inner != null) {
            return new OperationJobExtendedInfoImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationJobExtendedInfo validateForRestore(String resourceGroupName, String vaultName, String backupInstanceName, ValidateRestoreRequestObject parameters, Context context) {
        OperationJobExtendedInfoInner inner = this.serviceClient().validateForRestore(resourceGroupName, vaultName, backupInstanceName, parameters, context);
        if (inner != null) {
            return new OperationJobExtendedInfoImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationJobExtendedInfo triggerCrossRegionRestore(String resourceGroupName, String location, CrossRegionRestoreRequestObject parameters) {
        OperationJobExtendedInfoInner inner = this.serviceClient().triggerCrossRegionRestore(resourceGroupName, location, parameters);
        if (inner != null) {
            return new OperationJobExtendedInfoImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationJobExtendedInfo triggerCrossRegionRestore(String resourceGroupName, String location, CrossRegionRestoreRequestObject parameters, Context context) {
        OperationJobExtendedInfoInner inner = this.serviceClient().triggerCrossRegionRestore(resourceGroupName, location, parameters, context);
        if (inner != null) {
            return new OperationJobExtendedInfoImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationJobExtendedInfo validateCrossRegionRestore(String resourceGroupName, String location, ValidateCrossRegionRestoreRequestObject parameters) {
        OperationJobExtendedInfoInner inner = this.serviceClient().validateCrossRegionRestore(resourceGroupName, location, parameters);
        if (inner != null) {
            return new OperationJobExtendedInfoImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationJobExtendedInfo validateCrossRegionRestore(String resourceGroupName, String location, ValidateCrossRegionRestoreRequestObject parameters, Context context) {
        OperationJobExtendedInfoInner inner = this.serviceClient().validateCrossRegionRestore(resourceGroupName, location, parameters, context);
        if (inner != null) {
            return new OperationJobExtendedInfoImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public BackupInstanceResource getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String vaultName = ResourceManagerUtils.getValueFromIdByName(id, "backupVaults");
        if (vaultName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'backupVaults'.", id)));
        }
        String backupInstanceName = ResourceManagerUtils.getValueFromIdByName(id, "backupInstances");
        if (backupInstanceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'backupInstances'.", id)));
        }
        return (BackupInstanceResource)this.getWithResponse(resourceGroupName, vaultName, backupInstanceName, Context.NONE).getValue();
    }

    @Override
    public Response<BackupInstanceResource> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String vaultName = ResourceManagerUtils.getValueFromIdByName(id, "backupVaults");
        if (vaultName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'backupVaults'.", id)));
        }
        String backupInstanceName = ResourceManagerUtils.getValueFromIdByName(id, "backupInstances");
        if (backupInstanceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'backupInstances'.", id)));
        }
        return this.getWithResponse(resourceGroupName, vaultName, backupInstanceName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String vaultName = ResourceManagerUtils.getValueFromIdByName(id, "backupVaults");
        if (vaultName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'backupVaults'.", id)));
        }
        String backupInstanceName = ResourceManagerUtils.getValueFromIdByName(id, "backupInstances");
        if (backupInstanceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'backupInstances'.", id)));
        }
        this.delete(resourceGroupName, vaultName, backupInstanceName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String vaultName = ResourceManagerUtils.getValueFromIdByName(id, "backupVaults");
        if (vaultName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'backupVaults'.", id)));
        }
        String backupInstanceName = ResourceManagerUtils.getValueFromIdByName(id, "backupInstances");
        if (backupInstanceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'backupInstances'.", id)));
        }
        this.delete(resourceGroupName, vaultName, backupInstanceName, context);
    }

    private BackupInstancesClient serviceClient() {
        return this.innerClient;
    }

    private DataProtectionManager manager() {
        return this.serviceManager;
    }

    @Override
    public BackupInstanceResourceImpl define(String name) {
        return new BackupInstanceResourceImpl(name, this.manager());
    }
}

