/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.dataprotection.fluent.BackupInstancesExtensionRoutingsClient;
import com.azure.resourcemanager.dataprotection.fluent.models.BackupInstanceResourceInner;
import com.azure.resourcemanager.dataprotection.implementation.DataProtectionManagementClientImpl;
import com.azure.resourcemanager.dataprotection.implementation.models.BackupInstanceResourceList;
import reactor.core.publisher.Mono;

public final class BackupInstancesExtensionRoutingsClientImpl
implements BackupInstancesExtensionRoutingsClient {
    private final BackupInstancesExtensionRoutingsService service;
    private final DataProtectionManagementClientImpl client;

    BackupInstancesExtensionRoutingsClientImpl(DataProtectionManagementClientImpl client) {
        this.service = (BackupInstancesExtensionRoutingsService)RestProxy.create(BackupInstancesExtensionRoutingsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BackupInstanceResourceInner>> listSinglePageAsync(String resourceId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), resourceId, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BackupInstanceResourceList)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<BackupInstanceResourceInner> listAsync(String resourceId) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceId));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BackupInstanceResourceInner> listSinglePage(String resourceId) {
        String accept = "application/json";
        Response<BackupInstanceResourceList> res = this.service.listSync(this.client.getEndpoint(), this.client.getApiVersion(), resourceId, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BackupInstanceResourceList)res.getValue()).value(), null, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BackupInstanceResourceInner> listSinglePage(String resourceId, Context context) {
        String accept = "application/json";
        Response<BackupInstanceResourceList> res = this.service.listSync(this.client.getEndpoint(), this.client.getApiVersion(), resourceId, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BackupInstanceResourceList)res.getValue()).value(), null, null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BackupInstanceResourceInner> list(String resourceId) {
        return new PagedIterable(() -> this.listSinglePage(resourceId));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BackupInstanceResourceInner> list(String resourceId, Context context) {
        return new PagedIterable(() -> this.listSinglePage(resourceId, context));
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="DataProtectionManagementClientBackupInstancesExtensionRoutings")
    public static interface BackupInstancesExtensionRoutingsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{resourceId}/providers/Microsoft.DataProtection/backupInstances")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BackupInstanceResourceList>> list(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="resourceId", encoded=true) String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{resourceId}/providers/Microsoft.DataProtection/backupInstances")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BackupInstanceResourceList> listSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="resourceId", encoded=true) String var3, @HeaderParam(value="Accept") String var4, Context var5);
    }
}

