/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.EncryptionSettings;
import com.azure.resourcemanager.dataprotection.models.ImmutabilitySettings;
import com.azure.resourcemanager.dataprotection.models.SoftDeleteSettings;
import java.io.IOException;

public final class SecuritySettings
implements JsonSerializable<SecuritySettings> {
    private SoftDeleteSettings softDeleteSettings;
    private ImmutabilitySettings immutabilitySettings;
    private EncryptionSettings encryptionSettings;

    public SoftDeleteSettings softDeleteSettings() {
        return this.softDeleteSettings;
    }

    public SecuritySettings withSoftDeleteSettings(SoftDeleteSettings softDeleteSettings) {
        this.softDeleteSettings = softDeleteSettings;
        return this;
    }

    public ImmutabilitySettings immutabilitySettings() {
        return this.immutabilitySettings;
    }

    public SecuritySettings withImmutabilitySettings(ImmutabilitySettings immutabilitySettings) {
        this.immutabilitySettings = immutabilitySettings;
        return this;
    }

    public EncryptionSettings encryptionSettings() {
        return this.encryptionSettings;
    }

    public SecuritySettings withEncryptionSettings(EncryptionSettings encryptionSettings) {
        this.encryptionSettings = encryptionSettings;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("softDeleteSettings", (JsonSerializable)this.softDeleteSettings);
        jsonWriter.writeJsonField("immutabilitySettings", (JsonSerializable)this.immutabilitySettings);
        jsonWriter.writeJsonField("encryptionSettings", (JsonSerializable)this.encryptionSettings);
        return jsonWriter.writeEndObject();
    }

    public static SecuritySettings fromJson(JsonReader jsonReader) throws IOException {
        return (SecuritySettings)jsonReader.readObject(reader -> {
            SecuritySettings deserializedSecuritySettings = new SecuritySettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("softDeleteSettings".equals(fieldName)) {
                    deserializedSecuritySettings.softDeleteSettings = SoftDeleteSettings.fromJson(reader);
                    continue;
                }
                if ("immutabilitySettings".equals(fieldName)) {
                    deserializedSecuritySettings.immutabilitySettings = ImmutabilitySettings.fromJson(reader);
                    continue;
                }
                if ("encryptionSettings".equals(fieldName)) {
                    deserializedSecuritySettings.encryptionSettings = EncryptionSettings.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSecuritySettings;
        });
    }
}

