/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class RestoreJobRecoveryPointDetails
implements JsonSerializable<RestoreJobRecoveryPointDetails> {
    private String recoveryPointId;
    private OffsetDateTime recoveryPointTime;

    private RestoreJobRecoveryPointDetails() {
    }

    public String recoveryPointId() {
        return this.recoveryPointId;
    }

    public OffsetDateTime recoveryPointTime() {
        return this.recoveryPointTime;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("recoveryPointID", this.recoveryPointId);
        jsonWriter.writeStringField("recoveryPointTime", this.recoveryPointTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.recoveryPointTime));
        return jsonWriter.writeEndObject();
    }

    public static RestoreJobRecoveryPointDetails fromJson(JsonReader jsonReader) throws IOException {
        return (RestoreJobRecoveryPointDetails)jsonReader.readObject(reader -> {
            RestoreJobRecoveryPointDetails deserializedRestoreJobRecoveryPointDetails = new RestoreJobRecoveryPointDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("recoveryPointID".equals(fieldName)) {
                    deserializedRestoreJobRecoveryPointDetails.recoveryPointId = reader.getString();
                    continue;
                }
                if ("recoveryPointTime".equals(fieldName)) {
                    deserializedRestoreJobRecoveryPointDetails.recoveryPointTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRestoreJobRecoveryPointDetails;
        });
    }
}

