/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.ItemLevelRestoreCriteria;
import java.io.IOException;
import java.util.List;

public final class ItemPathBasedRestoreCriteria
extends ItemLevelRestoreCriteria {
    private String objectType = "ItemPathBasedRestoreCriteria";
    private String itemPath;
    private boolean isPathRelativeToBackupItem;
    private List<String> subItemPathPrefix;
    private String renameTo;

    @Override
    public String objectType() {
        return this.objectType;
    }

    public String itemPath() {
        return this.itemPath;
    }

    public ItemPathBasedRestoreCriteria withItemPath(String itemPath) {
        this.itemPath = itemPath;
        return this;
    }

    public boolean isPathRelativeToBackupItem() {
        return this.isPathRelativeToBackupItem;
    }

    public ItemPathBasedRestoreCriteria withIsPathRelativeToBackupItem(boolean isPathRelativeToBackupItem) {
        this.isPathRelativeToBackupItem = isPathRelativeToBackupItem;
        return this;
    }

    public List<String> subItemPathPrefix() {
        return this.subItemPathPrefix;
    }

    public ItemPathBasedRestoreCriteria withSubItemPathPrefix(List<String> subItemPathPrefix) {
        this.subItemPathPrefix = subItemPathPrefix;
        return this;
    }

    public String renameTo() {
        return this.renameTo;
    }

    public ItemPathBasedRestoreCriteria withRenameTo(String renameTo) {
        this.renameTo = renameTo;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("itemPath", this.itemPath);
        jsonWriter.writeBooleanField("isPathRelativeToBackupItem", this.isPathRelativeToBackupItem);
        jsonWriter.writeStringField("objectType", this.objectType);
        jsonWriter.writeArrayField("subItemPathPrefix", this.subItemPathPrefix, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("renameTo", this.renameTo);
        return jsonWriter.writeEndObject();
    }

    public static ItemPathBasedRestoreCriteria fromJson(JsonReader jsonReader) throws IOException {
        return (ItemPathBasedRestoreCriteria)jsonReader.readObject(reader -> {
            ItemPathBasedRestoreCriteria deserializedItemPathBasedRestoreCriteria = new ItemPathBasedRestoreCriteria();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("itemPath".equals(fieldName)) {
                    deserializedItemPathBasedRestoreCriteria.itemPath = reader.getString();
                    continue;
                }
                if ("isPathRelativeToBackupItem".equals(fieldName)) {
                    deserializedItemPathBasedRestoreCriteria.isPathRelativeToBackupItem = reader.getBoolean();
                    continue;
                }
                if ("objectType".equals(fieldName)) {
                    deserializedItemPathBasedRestoreCriteria.objectType = reader.getString();
                    continue;
                }
                if ("subItemPathPrefix".equals(fieldName)) {
                    List subItemPathPrefix;
                    deserializedItemPathBasedRestoreCriteria.subItemPathPrefix = subItemPathPrefix = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("renameTo".equals(fieldName)) {
                    deserializedItemPathBasedRestoreCriteria.renameTo = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedItemPathBasedRestoreCriteria;
        });
    }
}

